package arrow.data.extensions.coproduct.foldable

import arrow.Kind
import arrow.core.Eval
import arrow.core.ForEither
import arrow.core.Option
import arrow.data.Coproduct
import arrow.data.Coproduct.Companion
import arrow.data.ForCoproduct
import arrow.data.extensions.CoproductFoldable
import arrow.typeclasses.Applicative
import arrow.typeclasses.Foldable
import arrow.typeclasses.Monad
import arrow.typeclasses.Monoid
import kotlin.Boolean
import kotlin.Function1
import kotlin.Function2
import kotlin.Long
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("foldLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.foldLeft(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: B,
    arg2: Function2<B, A, B>
): B = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@foldLeft.foldLeft<A, B>(arg1, arg2) as B
}

@JvmName("foldRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.foldRight(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Eval<B>,
    arg2: Function2<A, Eval<B>, Eval<B>>
): Eval<B> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@foldRight.foldRight<A, B>(arg1, arg2) as arrow.core.Eval<B>
}

@JvmName("fold")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.fold(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Monoid<A>
): A = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@fold.fold<A>(arg1) as A
}

@JvmName("reduceLeftToOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.reduceLeftToOption(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Function1<A, B>,
    arg2: Function2<B, A, B>
): Option<B> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@reduceLeftToOption.reduceLeftToOption<A, B>(arg1, arg2) as arrow.core.Option<B>
}

@JvmName("reduceRightToOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.reduceRightToOption(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Function1<A, B>,
    arg2: Function2<A, Eval<B>, Eval<B>>
): Eval<Option<B>> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@reduceRightToOption.reduceRightToOption<A, B>(arg1, arg2) as arrow.core.Eval<arrow.core.Option<B>>
}

@JvmName("reduceLeftOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.reduceLeftOption(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Function2<A, A, A>
): Option<A> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@reduceLeftOption.reduceLeftOption<A>(arg1) as arrow.core.Option<A>
}

@JvmName("reduceRightOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.reduceRightOption(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Function2<A, Eval<A>, Eval<A>>
): Eval<Option<A>> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@reduceRightOption.reduceRightOption<A>(arg1) as arrow.core.Eval<arrow.core.Option<A>>
}

@JvmName("combineAll")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.combineAll(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Monoid<A>
): A = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@combineAll.combineAll<A>(arg1) as A
}

@JvmName("foldMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.foldMap(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Monoid<B>,
    arg2: Function1<A, B>
): B = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@foldMap.foldMap<A, B>(arg1, arg2) as B
}

@JvmName("orEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> orEmpty(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg0: Applicative<Kind<Kind<ForCoproduct, F>, G>>,
    arg1: Monoid<A>
): Coproduct<F, G, A> = arrow.data.Coproduct
   .foldable<F, G>(FF, FG)
   .orEmpty<A>(arg0, arg1) as arrow.data.Coproduct<F, G, A>

@JvmName("traverse_")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.traverse_(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Applicative<G>,
    arg2: Function1<A, Kind<G, B>>
): Kind<G, Unit> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@traverse_.traverse_<G, A, B>(arg1, arg2) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("sequence_")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, Kind<G, A>>.sequence_(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Applicative<G>
): Kind<G, Unit> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@sequence_.sequence_<G, A>(arg1) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("find")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.find(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Function1<A, Boolean>
): Option<A> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@find.find<A>(arg1) as arrow.core.Option<A>
}

@JvmName("exists")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.exists(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Function1<A, Boolean>
): Boolean = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@exists.exists<A>(arg1) as kotlin.Boolean
}

@JvmName("forAll")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.forAll(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Function1<A, Boolean>
): Boolean = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@forAll.forAll<A>(arg1) as kotlin.Boolean
}

@JvmName("isEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.isEmpty(FF: Foldable<F>, FG: Foldable<G>): Boolean = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@isEmpty.isEmpty<A>() as kotlin.Boolean
}

@JvmName("nonEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.nonEmpty(FF: Foldable<F>, FG: Foldable<G>): Boolean = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@nonEmpty.nonEmpty<A>() as kotlin.Boolean
}

@JvmName("size")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.size(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Monoid<Long>
): Long = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@size.size<A>(arg1) as kotlin.Long
}

@JvmName("foldMapM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B, MA : Monad<G>, MO : Monoid<B>> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.foldMapM(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: MA,
    arg2: MO,
    arg3: Function1<A, Kind<G, B>>
): Kind<G, B> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@foldMapM.foldMapM<G, A, B, MA, MO>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("foldM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.foldM(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Monad<G>,
    arg2: B,
    arg3: Function2<B, A, Kind<G, B>>
): Kind<G, B> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@foldM.foldM<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("get")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.get(
    FF: Foldable<F>,
    FG: Foldable<G>,
    arg1: Monad<Kind<ForEither, A>>,
    arg2: Long
): Option<A> = arrow.data.Coproduct.foldable<F, G>(FF, FG).run {
  this@get.get<A>(arg1, arg2) as arrow.core.Option<A>
}

fun <F, G> Companion.foldable(FF: Foldable<F>, FG: Foldable<G>): CoproductFoldable<F, G> = object : arrow.data.extensions.CoproductFoldable<F, G> { override fun FF(): arrow.typeclasses.Foldable<F> = FF

  override fun FG(): arrow.typeclasses.Foldable<G> = FG }