package arrow.data.extensions.coproduct.traverse

import arrow.Kind
import arrow.data.Coproduct
import arrow.data.Coproduct.Companion
import arrow.data.ForCoproduct
import arrow.data.extensions.CoproductTraverse
import arrow.typeclasses.Applicative
import arrow.typeclasses.Monad
import arrow.typeclasses.Traverse
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("traverse")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.traverse(
    TF: Traverse<F>,
    TG: Traverse<G>,
    arg1: Applicative<G>,
    arg2: Function1<A, Kind<G, B>>
): Kind<G, Kind<Kind<Kind<ForCoproduct, F>, G>, B>> = arrow.data.Coproduct.traverse<F, G>(TF, TG).run {
  this@traverse.traverse<G, A, B>(arg1, arg2) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForCoproduct, F>, G>, B>>
}

@JvmName("sequence")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, Kind<G, A>>.sequence(
    TF: Traverse<F>,
    TG: Traverse<G>,
    arg1: Applicative<G>
): Kind<G, Kind<Kind<Kind<ForCoproduct, F>, G>, A>> = arrow.data.Coproduct.traverse<F, G>(TF, TG).run {
  this@sequence.sequence<G, A>(arg1) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForCoproduct, F>, G>, A>>
}

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.map(
    TF: Traverse<F>,
    TG: Traverse<G>,
    arg1: Function1<A, B>
): Coproduct<F, G, B> = arrow.data.Coproduct.traverse<F, G>(TF, TG).run {
  this@map.map<A, B>(arg1) as arrow.data.Coproduct<F, G, B>
}

@JvmName("flatTraverse")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.flatTraverse(
    TF: Traverse<F>,
    TG: Traverse<G>,
    arg1: Monad<Kind<Kind<ForCoproduct, F>, G>>,
    arg2: Applicative<G>,
    arg3: Function1<A, Kind<G, Kind<Kind<Kind<ForCoproduct, F>, G>, B>>>
): Kind<G, Kind<Kind<Kind<ForCoproduct, F>, G>, B>> = arrow.data.Coproduct.traverse<F, G>(TF, TG).run {
  this@flatTraverse.flatTraverse<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForCoproduct, F>, G>, B>>
}

fun <F, G> Companion.traverse(TF: Traverse<F>, TG: Traverse<G>): CoproductTraverse<F, G> = object : arrow.data.extensions.CoproductTraverse<F, G> { override fun TF(): arrow.typeclasses.Traverse<F> = TF

  override fun TG(): arrow.typeclasses.Traverse<G> = TG }