package arrow.data.extensions.eithert.foldable

import arrow.Kind
import arrow.core.Eval
import arrow.core.ForEither
import arrow.core.Option
import arrow.data.EitherT
import arrow.data.EitherT.Companion
import arrow.data.ForEitherT
import arrow.data.extensions.EitherTFoldable
import arrow.typeclasses.Applicative
import arrow.typeclasses.Foldable
import arrow.typeclasses.Monad
import arrow.typeclasses.Monoid
import kotlin.Boolean
import kotlin.Function1
import kotlin.Function2
import kotlin.Long
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("foldLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.foldLeft(
    FFF: Foldable<F>,
    arg1: B,
    arg2: Function2<B, A, B>
): B = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@foldLeft.foldLeft<A, B>(arg1, arg2) as B
}

@JvmName("foldRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.foldRight(
    FFF: Foldable<F>,
    arg1: Eval<B>,
    arg2: Function2<A, Eval<B>, Eval<B>>
): Eval<B> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@foldRight.foldRight<A, B>(arg1, arg2) as arrow.core.Eval<B>
}

@JvmName("fold")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.fold(FFF: Foldable<F>, arg1: Monoid<A>): A = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@fold.fold<A>(arg1) as A
}

@JvmName("reduceLeftToOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.reduceLeftToOption(
    FFF: Foldable<F>,
    arg1: Function1<A, B>,
    arg2: Function2<B, A, B>
): Option<B> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@reduceLeftToOption.reduceLeftToOption<A, B>(arg1, arg2) as arrow.core.Option<B>
}

@JvmName("reduceRightToOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.reduceRightToOption(
    FFF: Foldable<F>,
    arg1: Function1<A, B>,
    arg2: Function2<A, Eval<B>, Eval<B>>
): Eval<Option<B>> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@reduceRightToOption.reduceRightToOption<A, B>(arg1, arg2) as arrow.core.Eval<arrow.core.Option<B>>
}

@JvmName("reduceLeftOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.reduceLeftOption(FFF: Foldable<F>, arg1: Function2<A, A, A>): Option<A> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@reduceLeftOption.reduceLeftOption<A>(arg1) as arrow.core.Option<A>
}

@JvmName("reduceRightOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.reduceRightOption(FFF: Foldable<F>, arg1: Function2<A, Eval<A>, Eval<A>>): Eval<Option<A>> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@reduceRightOption.reduceRightOption<A>(arg1) as arrow.core.Eval<arrow.core.Option<A>>
}

@JvmName("combineAll")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.combineAll(FFF: Foldable<F>, arg1: Monoid<A>): A = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@combineAll.combineAll<A>(arg1) as A
}

@JvmName("foldMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.foldMap(
    FFF: Foldable<F>,
    arg1: Monoid<B>,
    arg2: Function1<A, B>
): B = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@foldMap.foldMap<A, B>(arg1, arg2) as B
}

@JvmName("orEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> orEmpty(
    FFF: Foldable<F>,
    arg0: Applicative<Kind<Kind<ForEitherT, F>, L>>,
    arg1: Monoid<A>
): EitherT<F, L, A> = arrow.data.EitherT
   .foldable<F, L>(FFF)
   .orEmpty<A>(arg0, arg1) as arrow.data.EitherT<F, L, A>

@JvmName("traverse_")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, G, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.traverse_(
    FFF: Foldable<F>,
    arg1: Applicative<G>,
    arg2: Function1<A, Kind<G, B>>
): Kind<G, Unit> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@traverse_.traverse_<G, A, B>(arg1, arg2) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("sequence_")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, G, A> Kind<Kind<Kind<ForEitherT, F>, L>, Kind<G, A>>.sequence_(FFF: Foldable<F>, arg1: Applicative<G>): Kind<G, Unit> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@sequence_.sequence_<G, A>(arg1) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("find")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.find(FFF: Foldable<F>, arg1: Function1<A, Boolean>): Option<A> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@find.find<A>(arg1) as arrow.core.Option<A>
}

@JvmName("exists")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.exists(FFF: Foldable<F>, arg1: Function1<A, Boolean>): Boolean = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@exists.exists<A>(arg1) as kotlin.Boolean
}

@JvmName("forAll")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.forAll(FFF: Foldable<F>, arg1: Function1<A, Boolean>): Boolean = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@forAll.forAll<A>(arg1) as kotlin.Boolean
}

@JvmName("isEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.isEmpty(FFF: Foldable<F>): Boolean = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@isEmpty.isEmpty<A>() as kotlin.Boolean
}

@JvmName("nonEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.nonEmpty(FFF: Foldable<F>): Boolean = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@nonEmpty.nonEmpty<A>() as kotlin.Boolean
}

@JvmName("size")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.size(FFF: Foldable<F>, arg1: Monoid<Long>): Long = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@size.size<A>(arg1) as kotlin.Long
}

@JvmName("foldMapM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, G, A, B, MA : Monad<G>, MO : Monoid<B>> Kind<Kind<Kind<ForEitherT, F>, L>, A>.foldMapM(
    FFF: Foldable<F>,
    arg1: MA,
    arg2: MO,
    arg3: Function1<A, Kind<G, B>>
): Kind<G, B> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@foldMapM.foldMapM<G, A, B, MA, MO>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("foldM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, G, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.foldM(
    FFF: Foldable<F>,
    arg1: Monad<G>,
    arg2: B,
    arg3: Function2<B, A, Kind<G, B>>
): Kind<G, B> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@foldM.foldM<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("get")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.get(
    FFF: Foldable<F>,
    arg1: Monad<Kind<ForEither, A>>,
    arg2: Long
): Option<A> = arrow.data.EitherT.foldable<F, L>(FFF).run {
  this@get.get<A>(arg1, arg2) as arrow.core.Option<A>
}

fun <F, L> Companion.foldable(FFF: Foldable<F>): EitherTFoldable<F, L> = object : arrow.data.extensions.EitherTFoldable<F, L> { override fun FFF(): arrow.typeclasses.Foldable<F> = FFF }