package arrow.data.extensions.eithert.functor

import arrow.Kind
import arrow.core.Tuple2
import arrow.data.EitherT
import arrow.data.EitherT.Companion
import arrow.data.ForEitherT
import arrow.data.extensions.EitherTFunctor
import arrow.typeclasses.Functor
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.map(FF: Functor<F>, arg1: Function1<A, B>): EitherT<F, L, B> = arrow.data.EitherT.functor<F, L>(FF).run {
  this@map.map<A, B>(arg1) as arrow.data.EitherT<F, L, B>
}

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.imap(
    FF: Functor<F>,
    arg1: Function1<A, B>,
    arg2: Function1<B, A>
): EitherT<F, L, B> = arrow.data.EitherT.functor<F, L>(FF).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.EitherT<F, L, B>
}

@JvmName("lift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> lift(FF: Functor<F>, arg0: Function1<A, B>): Function1<Kind<Kind<Kind<ForEitherT, F>, L>, A>, Kind<Kind<Kind<ForEitherT, F>, L>, B>> = arrow.data.EitherT
   .functor<F, L>(FF)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForEitherT, F>, L>, A>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForEitherT, F>, L>, B>>

@JvmName("unit")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.unit(FF: Functor<F>): EitherT<F, L, Unit> = arrow.data.EitherT.functor<F, L>(FF).run {
  this@unit.unit<A>() as arrow.data.EitherT<F, L, kotlin.Unit>
}

@JvmName("fproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.fproduct(FF: Functor<F>, arg1: Function1<A, B>): EitherT<F, L, Tuple2<A, B>> = arrow.data.EitherT.functor<F, L>(FF).run {
  this@fproduct.fproduct<A, B>(arg1) as arrow.data.EitherT<F, L, arrow.core.Tuple2<A, B>>
}

@JvmName("as")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.`as`(FF: Functor<F>, arg1: B): EitherT<F, L, B> = arrow.data.EitherT.functor<F, L>(FF).run {
  this@`as`.`as`<A, B>(arg1) as arrow.data.EitherT<F, L, B>
}

@JvmName("tupleLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.tupleLeft(FF: Functor<F>, arg1: B): EitherT<F, L, Tuple2<B, A>> = arrow.data.EitherT.functor<F, L>(FF).run {
  this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.data.EitherT<F, L, arrow.core.Tuple2<B, A>>
}

@JvmName("tupleRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.tupleRight(FF: Functor<F>, arg1: B): EitherT<F, L, Tuple2<A, B>> = arrow.data.EitherT.functor<F, L>(FF).run {
  this@tupleRight.tupleRight<A, B>(arg1) as arrow.data.EitherT<F, L, arrow.core.Tuple2<A, B>>
}

@JvmName("widen")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, L, B, A : B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.widen(FF: Functor<F>): EitherT<F, L, B> = arrow.data.EitherT.functor<F, L>(FF).run {
  this@widen.widen<B, A>() as arrow.data.EitherT<F, L, B>
}

fun <F, L> Companion.functor(FF: Functor<F>): EitherTFunctor<F, L> = object : arrow.data.extensions.EitherTFunctor<F, L> { override fun FF(): arrow.typeclasses.Functor<F> = FF }