package arrow.data.extensions.eithert.monadThrow

import arrow.Kind
import arrow.data.EitherT
import arrow.data.EitherT.Companion
import arrow.data.ForEitherT
import arrow.data.extensions.EitherTMonadThrow
import arrow.typeclasses.ApplicativeError
import arrow.typeclasses.Monad
import arrow.typeclasses.MonadContinuation
import arrow.typeclasses.MonadErrorContinuation
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("bindingCatch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, B> bindingCatch(
    MF: Monad<F>,
    AE: ApplicativeError<F, Throwable>,
    arg0: suspend MonadErrorContinuation<Kind<Kind<ForEitherT, F>, Throwable>, *>.() -> B
): EitherT<F, Throwable, B> = arrow.data.EitherT
   .monadThrow<F>(MF, AE)
   .bindingCatch<B>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, B>

@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, B> binding(
    MF: Monad<F>,
    AE: ApplicativeError<F, Throwable>,
    arg0: suspend MonadContinuation<Kind<Kind<ForEitherT, F>, Throwable>, *>.() -> B
): EitherT<F, Throwable, B> = arrow.data.EitherT
   .monadThrow<F>(MF, AE)
   .binding<B>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, B>

@JvmName("raiseNonFatal")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> Throwable.raiseNonFatal(MF: Monad<F>, AE: ApplicativeError<F, Throwable>): EitherT<F, Throwable, A> = arrow.data.EitherT.monadThrow<F>(MF, AE).run {
  this@raiseNonFatal.raiseNonFatal<A>() as arrow.data.EitherT<F, kotlin.Throwable, A>
}

fun <F> Companion.monadThrow(MF: Monad<F>, AE: ApplicativeError<F, Throwable>): EitherTMonadThrow<F> = object : arrow.data.extensions.EitherTMonadThrow<F> { override fun MF(): arrow.typeclasses.Monad<F> = MF

  override fun AE(): arrow.typeclasses.ApplicativeError<F, kotlin.Throwable> = AE }