package arrow.data.extensions.ior.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.data.ForIor
import arrow.data.Ior
import arrow.data.Ior.Companion
import arrow.data.extensions.IorMonad
import arrow.typeclasses.MonadContinuation
import arrow.typeclasses.Semigroup
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, A>.flatMap(SL: Semigroup<L>, arg1: Function1<A, Kind<Kind<ForIor, L>, B>>): Ior<L, B> = arrow.data.Ior.monad<L>(SL).run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.data.Ior<L, B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> tailRecM(
    SL: Semigroup<L>,
    arg0: A,
    arg1: Function1<A, Kind<Kind<ForIor, L>, Either<A, B>>>
): Ior<L, B> = arrow.data.Ior
   .monad<L>(SL)
   .tailRecM<A, B>(arg0, arg1) as arrow.data.Ior<L, B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, A>.map(SL: Semigroup<L>, arg1: Function1<A, B>): Ior<L, B> = arrow.data.Ior.monad<L>(SL).run {
  this@map.map<A, B>(arg1) as arrow.data.Ior<L, B>
}

/**
 * @see [Applicative.ap]
 */
@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, A>.ap(SL: Semigroup<L>, arg1: Kind<Kind<ForIor, L>, Function1<A, B>>): Ior<L, B> = arrow.data.Ior.monad<L>(SL).run {
  this@ap.ap<A, B>(arg1) as arrow.data.Ior<L, B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A> Kind<Kind<ForIor, L>, Kind<Kind<ForIor, L>, A>>.flatten(SL: Semigroup<L>): Ior<L, A> = arrow.data.Ior.monad<L>(SL).run {
  this@flatten.flatten<A>() as arrow.data.Ior<L, A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, A>.followedBy(SL: Semigroup<L>, arg1: Kind<Kind<ForIor, L>, B>): Ior<L, B> = arrow.data.Ior.monad<L>(SL).run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.data.Ior<L, B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, A>.followedByEval(SL: Semigroup<L>, arg1: Eval<Kind<Kind<ForIor, L>, B>>): Ior<L, B> = arrow.data.Ior.monad<L>(SL).run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.data.Ior<L, B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, A>.effectM(SL: Semigroup<L>, arg1: Function1<A, Kind<Kind<ForIor, L>, B>>): Ior<L, A> = arrow.data.Ior.monad<L>(SL).run {
  this@effectM.effectM<A, B>(arg1) as arrow.data.Ior<L, A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, A>.forEffect(SL: Semigroup<L>, arg1: Kind<Kind<ForIor, L>, B>): Ior<L, A> = arrow.data.Ior.monad<L>(SL).run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.data.Ior<L, A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, A>.forEffectEval(SL: Semigroup<L>, arg1: Eval<Kind<Kind<ForIor, L>, B>>): Ior<L, A> = arrow.data.Ior.monad<L>(SL).run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.data.Ior<L, A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, A>.mproduct(SL: Semigroup<L>, arg1: Function1<A, Kind<Kind<ForIor, L>, B>>): Ior<L, Tuple2<A, B>> = arrow.data.Ior.monad<L>(SL).run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.data.Ior<L, arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, B> Kind<Kind<ForIor, L>, Boolean>.ifM(
    SL: Semigroup<L>,
    arg1: Function0<Kind<Kind<ForIor, L>, B>>,
    arg2: Function0<Kind<Kind<ForIor, L>, B>>
): Ior<L, B> = arrow.data.Ior.monad<L>(SL).run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.data.Ior<L, B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, Either<A, B>>.selectM(SL: Semigroup<L>, arg1: Kind<Kind<ForIor, L>, Function1<A, B>>): Ior<L, B> = arrow.data.Ior.monad<L>(SL).run {
  this@selectM.selectM<A, B>(arg1) as arrow.data.Ior<L, B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A, B> Kind<Kind<ForIor, L>, Either<A, B>>.select(SL: Semigroup<L>, arg1: Kind<Kind<ForIor, L>, Function1<A, B>>): Ior<L, B> = arrow.data.Ior.monad<L>(SL).run {
  this@select.select<A, B>(arg1) as arrow.data.Ior<L, B>
}

/**
 * Entry point for monad bindings which enables for comprehension. The underlying implementation is based on coroutines.
 * A coroutine is initiated and suspended inside [MonadErrorContinuation] yielding to [Monad.flatMap]. Once all the flatMap binds are completed
 * the underlying monad is returned from the act of executing the coroutine
 */
@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <L, A> binding(SL: Semigroup<L>, arg0: suspend MonadContinuation<Kind<ForIor, L>, *>.() -> A): Ior<L, A> = arrow.data.Ior
   .monad<L>(SL)
   .binding<A>(arg0) as arrow.data.Ior<L, A>

/**
 * ank_macro_hierarchy(arrow.typeclasses.Monad)
 *
 * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
 * the results of previous computations.
 *
 * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
 * `Kind<F, ?>` where `?` denotes a value being transformed.
 *
 * This is true for all type constructors that can support the [Monad] type class including and not limited to
 * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
 *
 * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
 *
 */
fun <L> Companion.monad(SL: Semigroup<L>): IorMonad<L> = object : arrow.data.extensions.IorMonad<L> { override fun SL(): arrow.typeclasses.Semigroup<L> = SL }