package arrow.data.extensions.kleisli.contravariant

import arrow.Kind
import arrow.data.ForKleisli
import arrow.data.Kleisli
import arrow.data.Kleisli.Companion
import arrow.data.extensions.KleisliContravariantInstance
import arrow.typeclasses.Contravariant
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("contramap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.contramap(CF: Contravariant<F>, arg1: Function1<B, A>): Kleisli<F, D, B> = arrow.data.Kleisli.contravariant<F, D>(CF).run {
  this@contramap.contramap<A, B>(arg1) as arrow.data.Kleisli<F, D, B>
}

@JvmName("lift1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> lift(CF: Contravariant<F>, arg0: Function1<A, B>): Function1<Kind<Kind<Kind<ForKleisli, F>, D>, B>, Kind<Kind<Kind<ForKleisli, F>, D>, A>> = arrow.data.Kleisli
   .contravariant<F, D>(CF)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForKleisli, F>, D>, B>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForKleisli, F>, D>, A>>

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.imap(
    CF: Contravariant<F>,
    arg1: Function1<A, B>,
    arg2: Function1<B, A>
): Kleisli<F, D, B> = arrow.data.Kleisli.contravariant<F, D>(CF).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.Kleisli<F, D, B>
}

@JvmName("narrow")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B : A> Kind<Kind<Kind<ForKleisli, F>, D>, A>.narrow(CF: Contravariant<F>): Kleisli<F, D, B> = arrow.data.Kleisli.contravariant<F, D>(CF).run {
  this@narrow.narrow<A, B>() as arrow.data.Kleisli<F, D, B>
}

fun <F, D> Companion.contravariant(CF: Contravariant<F>): KleisliContravariantInstance<F, D> = object : arrow.data.extensions.KleisliContravariantInstance<F, D> { override fun CF(): arrow.typeclasses.Contravariant<F> = CF }