package arrow.data.extensions.kleisli.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.data.ForKleisli
import arrow.data.Kleisli
import arrow.data.Kleisli.Companion
import arrow.data.extensions.KleisliMonad
import arrow.typeclasses.Monad
import arrow.typeclasses.MonadContinuation
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.flatMap(MF: Monad<F>, arg1: Function1<A, Kind<Kind<Kind<ForKleisli, F>, D>, B>>): Kleisli<F, D, B> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.data.Kleisli<F, D, B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> tailRecM(
    MF: Monad<F>,
    arg0: A,
    arg1: Function1<A, Kind<Kind<Kind<ForKleisli, F>, D>, Either<A, B>>>
): Kleisli<F, D, B> = arrow.data.Kleisli
   .monad<F, D>(MF)
   .tailRecM<A, B>(arg0, arg1) as arrow.data.Kleisli<F, D, B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.map(MF: Monad<F>, arg1: Function1<A, B>): Kleisli<F, D, B> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@map.map<A, B>(arg1) as arrow.data.Kleisli<F, D, B>
}

/**
 * @see [Applicative.ap]
 */
@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.ap(MF: Monad<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Function1<A, B>>): Kleisli<F, D, B> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@ap.ap<A, B>(arg1) as arrow.data.Kleisli<F, D, B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A> Kind<Kind<Kind<ForKleisli, F>, D>, Kind<Kind<Kind<ForKleisli, F>, D>, A>>.flatten(MF: Monad<F>): Kleisli<F, D, A> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@flatten.flatten<A>() as arrow.data.Kleisli<F, D, A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.followedBy(MF: Monad<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>): Kleisli<F, D, B> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.data.Kleisli<F, D, B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.followedByEval(MF: Monad<F>, arg1: Eval<Kind<Kind<Kind<ForKleisli, F>, D>, B>>): Kleisli<F, D, B> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.data.Kleisli<F, D, B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.effectM(MF: Monad<F>, arg1: Function1<A, Kind<Kind<Kind<ForKleisli, F>, D>, B>>): Kleisli<F, D, A> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@effectM.effectM<A, B>(arg1) as arrow.data.Kleisli<F, D, A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.forEffect(MF: Monad<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>): Kleisli<F, D, A> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.data.Kleisli<F, D, A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.forEffectEval(MF: Monad<F>, arg1: Eval<Kind<Kind<Kind<ForKleisli, F>, D>, B>>): Kleisli<F, D, A> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.data.Kleisli<F, D, A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.mproduct(MF: Monad<F>, arg1: Function1<A, Kind<Kind<Kind<ForKleisli, F>, D>, B>>): Kleisli<F, D, Tuple2<A, B>> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.data.Kleisli<F, D, arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, B> Kind<Kind<Kind<ForKleisli, F>, D>, Boolean>.ifM(
    MF: Monad<F>,
    arg1: Function0<Kind<Kind<Kind<ForKleisli, F>, D>, B>>,
    arg2: Function0<Kind<Kind<Kind<ForKleisli, F>, D>, B>>
): Kleisli<F, D, B> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.data.Kleisli<F, D, B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, Either<A, B>>.selectM(MF: Monad<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Function1<A, B>>): Kleisli<F, D, B> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@selectM.selectM<A, B>(arg1) as arrow.data.Kleisli<F, D, B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, Either<A, B>>.select(MF: Monad<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Function1<A, B>>): Kleisli<F, D, B> = arrow.data.Kleisli.monad<F, D>(MF).run {
  this@select.select<A, B>(arg1) as arrow.data.Kleisli<F, D, B>
}

/**
 * Entry point for monad bindings which enables for comprehension. The underlying implementation is based on coroutines.
 * A coroutine is initiated and suspended inside [MonadErrorContinuation] yielding to [Monad.flatMap]. Once all the flatMap binds are completed
 * the underlying monad is returned from the act of executing the coroutine
 */
@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, A> binding(MF: Monad<F>, arg0: suspend MonadContinuation<Kind<Kind<ForKleisli, F>, D>, *>.() -> A): Kleisli<F, D, A> = arrow.data.Kleisli
   .monad<F, D>(MF)
   .binding<A>(arg0) as arrow.data.Kleisli<F, D, A>

/**
 * ank_macro_hierarchy(arrow.typeclasses.Monad)
 *
 * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
 * the results of previous computations.
 *
 * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
 * `Kind<F, ?>` where `?` denotes a value being transformed.
 *
 * This is true for all type constructors that can support the [Monad] type class including and not limited to
 * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
 *
 * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
 *
 */
fun <F, D> Companion.monad(MF: Monad<F>): KleisliMonad<F, D> = object : arrow.data.extensions.KleisliMonad<F, D> { override fun MF(): arrow.typeclasses.Monad<F> = MF }