package arrow.data.extensions.kleisli.monadError

import arrow.Kind
import arrow.data.ForKleisli
import arrow.data.Kleisli
import arrow.data.Kleisli.Companion
import arrow.data.extensions.KleisliMonadError
import arrow.typeclasses.MonadError
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("ensure")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, D, E, A> Kind<Kind<Kind<ForKleisli, F>, D>, A>.ensure(
    ME: MonadError<F, E>,
    arg1: Function0<E>,
    arg2: Function1<A, Boolean>
): Kleisli<F, D, A> = arrow.data.Kleisli.monadError<F, D, E>(ME).run {
  this@ensure.ensure<A>(arg1, arg2) as arrow.data.Kleisli<F, D, A>
}

fun <F, D, E> Companion.monadError(ME: MonadError<F, E>): KleisliMonadError<F, D, E> = object : arrow.data.extensions.KleisliMonadError<F, D, E> { override fun ME(): arrow.typeclasses.MonadError<F, E> = ME }