package arrow.data.extensions.list.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.data.ForListK
import arrow.data.extensions.ListKMonad
import arrow.typeclasses.MonadContinuation
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<A>.flatMap(arg1: Function1<A, Kind<ForListK, B>>): List<B> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@flatMap).flatMap<A, B>(arg1) as kotlin.collections.List<B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> tailRecM(arg0: A, arg1: Function1<A, Kind<ForListK, Either<A, B>>>): List<B> = arrow.data.extensions.list.monad.List
   .monad()
   .tailRecM<A, B>(arg0, arg1) as kotlin.collections.List<B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<A>.map(arg1: Function1<A, B>): List<B> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@map).map<A, B>(arg1) as kotlin.collections.List<B>
}

/**
 * @see [Applicative.ap]
 */
@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<A>.ap(arg1: List<Function1<A, B>>): List<B> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@ap).ap<A, B>(arrow.data.ListK(arg1)) as kotlin.collections.List<B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> List<List<A>>.flatten(): List<A> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@flatten).flatten<A>() as kotlin.collections.List<A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<A>.followedBy(arg1: List<B>): List<B> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@followedBy).followedBy<A, B>(arrow.data.ListK(arg1)) as kotlin.collections.List<B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<A>.followedByEval(arg1: Eval<Kind<ForListK, B>>): List<B> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@followedByEval).followedByEval<A, B>(arg1) as kotlin.collections.List<B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<A>.effectM(arg1: Function1<A, Kind<ForListK, B>>): List<A> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@effectM).effectM<A, B>(arg1) as kotlin.collections.List<A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<A>.forEffect(arg1: List<B>): List<A> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@forEffect).forEffect<A, B>(arrow.data.ListK(arg1)) as kotlin.collections.List<A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<A>.forEffectEval(arg1: Eval<Kind<ForListK, B>>): List<A> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@forEffectEval).forEffectEval<A, B>(arg1) as kotlin.collections.List<A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<A>.mproduct(arg1: Function1<A, Kind<ForListK, B>>): List<Tuple2<A, B>> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@mproduct).mproduct<A, B>(arg1) as kotlin.collections.List<arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <B> List<Boolean>.ifM(arg1: Function0<Kind<ForListK, B>>, arg2: Function0<Kind<ForListK, B>>): List<B> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@ifM).ifM<B>(arg1, arg2) as kotlin.collections.List<B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<Either<A, B>>.selectM(arg1: List<Function1<A, B>>): List<B> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@selectM).selectM<A, B>(arrow.data.ListK(arg1)) as kotlin.collections.List<B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> List<Either<A, B>>.select(arg1: List<Function1<A, B>>): List<B> = arrow.data.extensions.list.monad.List.monad().run {
  arrow.data.ListK(this@select).select<A, B>(arrow.data.ListK(arg1)) as kotlin.collections.List<B>
}

/**
 * Entry point for monad bindings which enables for comprehension. The underlying implementation is based on coroutines.
 * A coroutine is initiated and suspended inside [MonadErrorContinuation] yielding to [Monad.flatMap]. Once all the flatMap binds are completed
 * the underlying monad is returned from the act of executing the coroutine
 */
@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> binding(arg0: suspend MonadContinuation<ForListK, *>.() -> A): List<A> = arrow.data.extensions.list.monad.List
   .monad()
   .binding<A>(arg0) as kotlin.collections.List<A>

object List {
    /**
     * ank_macro_hierarchy(arrow.typeclasses.Monad)
     *
     * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
     * the results of previous computations.
     *
     * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
     * `Kind<F, ?>` where `?` denotes a value being transformed.
     *
     * This is true for all type constructors that can support the [Monad] type class including and not limited to
     * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
     *
     * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
     *
     */
    fun monad(): ListKMonad = object : arrow.data.extensions.ListKMonad {  }}
