package arrow.data.extensions.listk.semigroupal

import arrow.Kind
import arrow.core.Tuple2
import arrow.data.ForListK
import arrow.data.ListK
import arrow.data.ListK.Companion
import arrow.data.extensions.ListKSemigroupal
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Multiplicatively combine F<A> and F<B> into F<Tuple2<A, B>>
 */
@JvmName("product")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForListK, A>.product(arg1: Kind<ForListK, B>): ListK<Tuple2<A, B>> = arrow.data.ListK.semigroupal().run {
  this@product.product<A, B>(arg1) as arrow.data.ListK<arrow.core.Tuple2<A, B>>
}

/**
 * Add support for the * syntax
 */
@JvmName("times")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
operator fun <A, B> Kind<ForListK, A>.times(arg1: Kind<ForListK, B>): ListK<Tuple2<A, B>> = arrow.data.ListK.semigroupal().run {
  this@times.times<A, B>(arg1) as arrow.data.ListK<arrow.core.Tuple2<A, B>>
}

/**
 * ank_macro_hierarchy(arrow.typeclasses.Semigroupal)
 *
 * The [Semigroupal] type class for a given type `F` can be seen as an abstraction over the [cartesian product](https://en.wikipedia.org/wiki/Cartesian_product).
 * It defines the function [product].
 *
 * The [product] function for a given type `F`, `A` and `B` combines a `Kind<F, A>` and a `Kind<F, B>` into a `Kind<F, Tuple2<A, B>>`.
 * This function guarantees compliance with the following laws:
 *
 * [Semigroupal]s are associative under the bijection `f = (a,(b,c)) -> ((a,b),c)` or `f = ((a,b),c) -> (a,(b,c))`.
 * Therefore, the following laws also apply:
 *
 * ```kotlin
 * f((a.product(b)).product(c)) == a.product(b.product(c))
 * ```
 *
 * ```kotlin
 * f(a.product(b.product(c))) == (a.product(b)).product(c)
 * ```
 *
 * Currently, [Semigroupal] instances are defined for [Option], [ListK], [SequenceK] and [SetK].
 *
 * ```kotlin:ank:playground
 * import arrow.data.*
 * import arrow.data.extensions.listk.semigroupal.*
 * import arrow.core.*
 *
 *
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   ListK.semigroupal()
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 *
 * ### Examples
 *
 * Here a some examples:
 *
 * ```kotlin:ank:playground
 * import arrow.core.Option
 * import arrow.core.extensions.option.semigroupal.semigroupal
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   Option.semigroupal().run {
 *       Option.just(1).product(Option.just(1))
 *   }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 *
 * [Semigroupal] also has support of the `*` syntax:
 *
 * ```kotlin:ank:playground
 * import arrow.core.Option
 * import arrow.core.extensions.option.semigroupal.semigroupal
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   Option.semigroupal().run {
 *       Option.just(1) * Option.just(2)
 *   }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 * The same applies to [ListK], [SequenceK] and [SetK] instances:
 *
 * ```kotlin:ank:playground
 * import arrow.data.ListK
 * import arrow.data.extensions.listk.semigroupal.semigroupal
 * import arrow.data.k
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   ListK.semigroupal().run {
 *       listOf(1,2,3).k() * listOf('a','b','c').k()
 *   }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 */
fun Companion.semigroupal(): ListKSemigroupal = object : arrow.data.extensions.ListKSemigroupal {  }