package arrow.data.extensions.moore.functor

import arrow.Kind
import arrow.core.Tuple2
import arrow.data.ForMoore
import arrow.data.Moore
import arrow.data.Moore.Companion
import arrow.data.extensions.MooreFunctor
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.map(arg1: Function1<A, B>): Moore<V, B> = arrow.data.Moore.functor<V>().run {
  this@map.map<A, B>(arg1) as arrow.data.Moore<V, B>
}

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.imap(arg1: Function1<A, B>, arg2: Function1<B, A>): Moore<V, B> = arrow.data.Moore.functor<V>().run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.Moore<V, B>
}

@JvmName("lift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <V, A, B> lift(arg0: Function1<A, B>): Function1<Kind<Kind<ForMoore, V>, A>, Kind<Kind<ForMoore, V>, B>> = arrow.data.Moore
   .functor<V>()
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.data.ForMoore, V>, A>, arrow.Kind<arrow.Kind<arrow.data.ForMoore, V>, B>>

@JvmName("unit")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <V, A> Kind<Kind<ForMoore, V>, A>.unit(): Moore<V, Unit> = arrow.data.Moore.functor<V>().run {
  this@unit.unit<A>() as arrow.data.Moore<V, kotlin.Unit>
}

@JvmName("fproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.fproduct(arg1: Function1<A, B>): Moore<V, Tuple2<A, B>> = arrow.data.Moore.functor<V>().run {
  this@fproduct.fproduct<A, B>(arg1) as arrow.data.Moore<V, arrow.core.Tuple2<A, B>>
}

@JvmName("as")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.`as`(arg1: B): Moore<V, B> = arrow.data.Moore.functor<V>().run {
  this@`as`.`as`<A, B>(arg1) as arrow.data.Moore<V, B>
}

@JvmName("tupleLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.tupleLeft(arg1: B): Moore<V, Tuple2<B, A>> = arrow.data.Moore.functor<V>().run {
  this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.data.Moore<V, arrow.core.Tuple2<B, A>>
}

@JvmName("tupleRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <V, A, B> Kind<Kind<ForMoore, V>, A>.tupleRight(arg1: B): Moore<V, Tuple2<A, B>> = arrow.data.Moore.functor<V>().run {
  this@tupleRight.tupleRight<A, B>(arg1) as arrow.data.Moore<V, arrow.core.Tuple2<A, B>>
}

@JvmName("widen")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <V, B, A : B> Kind<Kind<ForMoore, V>, A>.widen(): Moore<V, B> = arrow.data.Moore.functor<V>().run {
  this@widen.widen<B, A>() as arrow.data.Moore<V, B>
}

fun <V> Companion.functor(): MooreFunctor<V> = object : arrow.data.extensions.MooreFunctor<V> {  }