package arrow.data.extensions.sequence.foldable

import arrow.Kind
import arrow.core.Eval
import arrow.core.ForEither
import arrow.core.Option
import arrow.data.ForSequenceK
import arrow.data.extensions.SequenceKFoldable
import arrow.typeclasses.Applicative
import arrow.typeclasses.Monad
import arrow.typeclasses.Monoid
import kotlin.Boolean
import kotlin.Function1
import kotlin.Function2
import kotlin.Long
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName
import kotlin.sequences.Sequence

@JvmName("foldLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.foldLeft(arg1: B, arg2: Function2<B, A, B>): B = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@foldLeft).foldLeft<A, B>(arg1, arg2) as B
}

@JvmName("foldRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.foldRight(arg1: Eval<B>, arg2: Function2<A, Eval<B>, Eval<B>>): Eval<B> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@foldRight).foldRight<A, B>(arg1, arg2) as arrow.core.Eval<B>
}

@JvmName("fold")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.fold(arg1: Monoid<A>): A = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@fold).fold<A>(arg1) as A
}

@JvmName("reduceLeftToOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.reduceLeftToOption(arg1: Function1<A, B>, arg2: Function2<B, A, B>): Option<B> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@reduceLeftToOption).reduceLeftToOption<A, B>(arg1, arg2) as arrow.core.Option<B>
}

@JvmName("reduceRightToOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.reduceRightToOption(arg1: Function1<A, B>, arg2: Function2<A, Eval<B>, Eval<B>>): Eval<Option<B>> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@reduceRightToOption).reduceRightToOption<A, B>(arg1, arg2) as arrow.core.Eval<arrow.core.Option<B>>
}

@JvmName("reduceLeftOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.reduceLeftOption(arg1: Function2<A, A, A>): Option<A> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@reduceLeftOption).reduceLeftOption<A>(arg1) as arrow.core.Option<A>
}

@JvmName("reduceRightOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.reduceRightOption(arg1: Function2<A, Eval<A>, Eval<A>>): Eval<Option<A>> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@reduceRightOption).reduceRightOption<A>(arg1) as arrow.core.Eval<arrow.core.Option<A>>
}

@JvmName("combineAll")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.combineAll(arg1: Monoid<A>): A = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@combineAll).combineAll<A>(arg1) as A
}

@JvmName("foldMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.foldMap(arg1: Monoid<B>, arg2: Function1<A, B>): B = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@foldMap).foldMap<A, B>(arg1, arg2) as B
}

@JvmName("orEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> orEmpty(arg0: Applicative<ForSequenceK>, arg1: Monoid<A>): Sequence<A> = arrow.data.extensions.sequence.foldable.Sequence
   .foldable()
   .orEmpty<A>(arg0, arg1) as kotlin.sequences.Sequence<A>

@JvmName("traverse_")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <G, A, B> Sequence<A>.traverse_(arg1: Applicative<G>, arg2: Function1<A, Kind<G, B>>): Kind<G, Unit> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@traverse_).traverse_<G, A, B>(arg1, arg2) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("sequence_")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <G, A> Sequence<Kind<G, A>>.sequence_(arg1: Applicative<G>): Kind<G, Unit> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@sequence_).sequence_<G, A>(arg1) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("find")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.find(arg1: Function1<A, Boolean>): Option<A> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@find).find<A>(arg1) as arrow.core.Option<A>
}

@JvmName("exists")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.exists(arg1: Function1<A, Boolean>): Boolean = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@exists).exists<A>(arg1) as kotlin.Boolean
}

@JvmName("forAll")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.forAll(arg1: Function1<A, Boolean>): Boolean = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@forAll).forAll<A>(arg1) as kotlin.Boolean
}

@JvmName("isEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.isEmpty(): Boolean = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@isEmpty).isEmpty<A>() as kotlin.Boolean
}

@JvmName("nonEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.nonEmpty(): Boolean = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@nonEmpty).nonEmpty<A>() as kotlin.Boolean
}

@JvmName("size")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.size(arg1: Monoid<Long>): Long = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@size).size<A>(arg1) as kotlin.Long
}

@JvmName("foldMapM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <G, A, B, MA : Monad<G>, MO : Monoid<B>> Sequence<A>.foldMapM(
    arg1: MA,
    arg2: MO,
    arg3: Function1<A, Kind<G, B>>
): Kind<G, B> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@foldMapM).foldMapM<G, A, B, MA, MO>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("foldM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <G, A, B> Sequence<A>.foldM(
    arg1: Monad<G>,
    arg2: B,
    arg3: Function2<B, A, Kind<G, B>>
): Kind<G, B> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@foldM).foldM<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("get")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<A>.get(arg1: Monad<Kind<ForEither, A>>, arg2: Long): Option<A> = arrow.data.extensions.sequence.foldable.Sequence.foldable().run {
  arrow.data.SequenceK(this@get).get<A>(arg1, arg2) as arrow.core.Option<A>
}

object Sequence {
    fun foldable(): SequenceKFoldable = object : arrow.data.extensions.SequenceKFoldable {  }}
