package arrow.data.extensions.sequence.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.data.ForSequenceK
import arrow.data.extensions.SequenceKMonad
import arrow.typeclasses.MonadContinuation
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName
import kotlin.sequences.Sequence

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.flatMap(arg1: Function1<A, Kind<ForSequenceK, B>>): Sequence<B> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@flatMap).flatMap<A, B>(arg1) as kotlin.sequences.Sequence<B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> tailRecM(arg0: A, arg1: Function1<A, Kind<ForSequenceK, Either<A, B>>>): Sequence<B> = arrow.data.extensions.sequence.monad.Sequence
   .monad()
   .tailRecM<A, B>(arg0, arg1) as kotlin.sequences.Sequence<B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.map(arg1: Function1<A, B>): Sequence<B> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@map).map<A, B>(arg1) as kotlin.sequences.Sequence<B>
}

/**
 * @see [Applicative.ap]
 */
@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.ap(arg1: Sequence<Function1<A, B>>): Sequence<B> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@ap).ap<A, B>(arrow.data.SequenceK(arg1)) as kotlin.sequences.Sequence<B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Sequence<Sequence<A>>.flatten(): Sequence<A> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@flatten).flatten<A>() as kotlin.sequences.Sequence<A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.followedBy(arg1: Sequence<B>): Sequence<B> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@followedBy).followedBy<A, B>(arrow.data.SequenceK(arg1)) as kotlin.sequences.Sequence<B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.followedByEval(arg1: Eval<Kind<ForSequenceK, B>>): Sequence<B> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@followedByEval).followedByEval<A, B>(arg1) as kotlin.sequences.Sequence<B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.effectM(arg1: Function1<A, Kind<ForSequenceK, B>>): Sequence<A> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@effectM).effectM<A, B>(arg1) as kotlin.sequences.Sequence<A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.forEffect(arg1: Sequence<B>): Sequence<A> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@forEffect).forEffect<A, B>(arrow.data.SequenceK(arg1)) as kotlin.sequences.Sequence<A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.forEffectEval(arg1: Eval<Kind<ForSequenceK, B>>): Sequence<A> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@forEffectEval).forEffectEval<A, B>(arg1) as kotlin.sequences.Sequence<A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<A>.mproduct(arg1: Function1<A, Kind<ForSequenceK, B>>): Sequence<Tuple2<A, B>> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@mproduct).mproduct<A, B>(arg1) as kotlin.sequences.Sequence<arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <B> Sequence<Boolean>.ifM(arg1: Function0<Kind<ForSequenceK, B>>, arg2: Function0<Kind<ForSequenceK, B>>): Sequence<B> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@ifM).ifM<B>(arg1, arg2) as kotlin.sequences.Sequence<B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<Either<A, B>>.selectM(arg1: Sequence<Function1<A, B>>): Sequence<B> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@selectM).selectM<A, B>(arrow.data.SequenceK(arg1)) as kotlin.sequences.Sequence<B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Sequence<Either<A, B>>.select(arg1: Sequence<Function1<A, B>>): Sequence<B> = arrow.data.extensions.sequence.monad.Sequence.monad().run {
  arrow.data.SequenceK(this@select).select<A, B>(arrow.data.SequenceK(arg1)) as kotlin.sequences.Sequence<B>
}

/**
 * Entry point for monad bindings which enables for comprehension. The underlying implementation is based on coroutines.
 * A coroutine is initiated and suspended inside [MonadErrorContinuation] yielding to [Monad.flatMap]. Once all the flatMap binds are completed
 * the underlying monad is returned from the act of executing the coroutine
 */
@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> binding(arg0: suspend MonadContinuation<ForSequenceK, *>.() -> A): Sequence<A> = arrow.data.extensions.sequence.monad.Sequence
   .monad()
   .binding<A>(arg0) as kotlin.sequences.Sequence<A>

object Sequence {
    /**
     * ank_macro_hierarchy(arrow.typeclasses.Monad)
     *
     * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
     * the results of previous computations.
     *
     * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
     * `Kind<F, ?>` where `?` denotes a value being transformed.
     *
     * This is true for all type constructors that can support the [Monad] type class including and not limited to
     * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
     *
     * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
     *
     */
    fun monad(): SequenceKMonad = object : arrow.data.extensions.SequenceKMonad {  }}
