package arrow.data.extensions.set.foldable

import arrow.Kind
import arrow.core.Eval
import arrow.core.ForEither
import arrow.core.Option
import arrow.data.ForSetK
import arrow.data.extensions.SetKFoldable
import arrow.typeclasses.Applicative
import arrow.typeclasses.Monad
import arrow.typeclasses.Monoid
import kotlin.Boolean
import kotlin.Function1
import kotlin.Function2
import kotlin.Long
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Set
import kotlin.jvm.JvmName

@JvmName("foldLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Set<A>.foldLeft(arg1: B, arg2: Function2<B, A, B>): B = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@foldLeft).foldLeft<A, B>(arg1, arg2) as B
}

@JvmName("foldRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Set<A>.foldRight(arg1: Eval<B>, arg2: Function2<A, Eval<B>, Eval<B>>): Eval<B> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@foldRight).foldRight<A, B>(arg1, arg2) as arrow.core.Eval<B>
}

@JvmName("fold")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Set<A>.fold(arg1: Monoid<A>): A = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@fold).fold<A>(arg1) as A
}

@JvmName("reduceLeftToOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Set<A>.reduceLeftToOption(arg1: Function1<A, B>, arg2: Function2<B, A, B>): Option<B> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@reduceLeftToOption).reduceLeftToOption<A, B>(arg1, arg2) as arrow.core.Option<B>
}

@JvmName("reduceRightToOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Set<A>.reduceRightToOption(arg1: Function1<A, B>, arg2: Function2<A, Eval<B>, Eval<B>>): Eval<Option<B>> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@reduceRightToOption).reduceRightToOption<A, B>(arg1, arg2) as arrow.core.Eval<arrow.core.Option<B>>
}

@JvmName("reduceLeftOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Set<A>.reduceLeftOption(arg1: Function2<A, A, A>): Option<A> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@reduceLeftOption).reduceLeftOption<A>(arg1) as arrow.core.Option<A>
}

@JvmName("reduceRightOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Set<A>.reduceRightOption(arg1: Function2<A, Eval<A>, Eval<A>>): Eval<Option<A>> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@reduceRightOption).reduceRightOption<A>(arg1) as arrow.core.Eval<arrow.core.Option<A>>
}

@JvmName("combineAll")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Set<A>.combineAll(arg1: Monoid<A>): A = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@combineAll).combineAll<A>(arg1) as A
}

@JvmName("foldMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Set<A>.foldMap(arg1: Monoid<B>, arg2: Function1<A, B>): B = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@foldMap).foldMap<A, B>(arg1, arg2) as B
}

@JvmName("orEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> orEmpty(arg0: Applicative<ForSetK>, arg1: Monoid<A>): Set<A> = arrow.data.extensions.set.foldable.Set
   .foldable()
   .orEmpty<A>(arg0, arg1) as kotlin.collections.Set<A>

@JvmName("traverse_")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <G, A, B> Set<A>.traverse_(arg1: Applicative<G>, arg2: Function1<A, Kind<G, B>>): Kind<G, Unit> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@traverse_).traverse_<G, A, B>(arg1, arg2) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("sequence_")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <G, A> Set<Kind<G, A>>.sequence_(arg1: Applicative<G>): Kind<G, Unit> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@sequence_).sequence_<G, A>(arg1) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("find")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Set<A>.find(arg1: Function1<A, Boolean>): Option<A> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@find).find<A>(arg1) as arrow.core.Option<A>
}

@JvmName("exists")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Set<A>.exists(arg1: Function1<A, Boolean>): Boolean = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@exists).exists<A>(arg1) as kotlin.Boolean
}

@JvmName("forAll")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Set<A>.forAll(arg1: Function1<A, Boolean>): Boolean = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@forAll).forAll<A>(arg1) as kotlin.Boolean
}

@JvmName("nonEmpty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Set<A>.nonEmpty(): Boolean = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@nonEmpty).nonEmpty<A>() as kotlin.Boolean
}

@JvmName("foldMapM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <G, A, B, MA : Monad<G>, MO : Monoid<B>> Set<A>.foldMapM(
    arg1: MA,
    arg2: MO,
    arg3: Function1<A, Kind<G, B>>
): Kind<G, B> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@foldMapM).foldMapM<G, A, B, MA, MO>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("foldM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <G, A, B> Set<A>.foldM(
    arg1: Monad<G>,
    arg2: B,
    arg3: Function2<B, A, Kind<G, B>>
): Kind<G, B> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@foldM).foldM<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("get")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Set<A>.get(arg1: Monad<Kind<ForEither, A>>, arg2: Long): Option<A> = arrow.data.extensions.set.foldable.Set.foldable().run {
  arrow.data.SetK(this@get).get<A>(arg1, arg2) as arrow.core.Option<A>
}

object Set {
    fun foldable(): SetKFoldable = object : arrow.data.extensions.SetKFoldable {  }}
