package arrow.data.extensions.statet.functor

import arrow.Kind
import arrow.core.Tuple2
import arrow.data.ForStateT
import arrow.data.StateT
import arrow.data.StateT.Companion
import arrow.data.extensions.StateTFunctor
import arrow.typeclasses.Functor
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.map(FF: Functor<F>, arg1: Function1<A, B>): StateT<F, S, B> = arrow.data.StateT.functor<F, S>(FF).run {
  this@map.map<A, B>(arg1) as arrow.data.StateT<F, S, B>
}

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.imap(
    FF: Functor<F>,
    arg1: Function1<A, B>,
    arg2: Function1<B, A>
): StateT<F, S, B> = arrow.data.StateT.functor<F, S>(FF).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.StateT<F, S, B>
}

@JvmName("lift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> lift(FF: Functor<F>, arg0: Function1<A, B>): Function1<Kind<Kind<Kind<ForStateT, F>, S>, A>, Kind<Kind<Kind<ForStateT, F>, S>, B>> = arrow.data.StateT
   .functor<F, S>(FF)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForStateT, F>, S>, A>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForStateT, F>, S>, B>>

@JvmName("unit")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> Kind<Kind<Kind<ForStateT, F>, S>, A>.unit(FF: Functor<F>): StateT<F, S, Unit> = arrow.data.StateT.functor<F, S>(FF).run {
  this@unit.unit<A>() as arrow.data.StateT<F, S, kotlin.Unit>
}

@JvmName("fproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.fproduct(FF: Functor<F>, arg1: Function1<A, B>): StateT<F, S, Tuple2<A, B>> = arrow.data.StateT.functor<F, S>(FF).run {
  this@fproduct.fproduct<A, B>(arg1) as arrow.data.StateT<F, S, arrow.core.Tuple2<A, B>>
}

@JvmName("as")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.`as`(FF: Functor<F>, arg1: B): StateT<F, S, B> = arrow.data.StateT.functor<F, S>(FF).run {
  this@`as`.`as`<A, B>(arg1) as arrow.data.StateT<F, S, B>
}

@JvmName("tupleLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.tupleLeft(FF: Functor<F>, arg1: B): StateT<F, S, Tuple2<B, A>> = arrow.data.StateT.functor<F, S>(FF).run {
  this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.data.StateT<F, S, arrow.core.Tuple2<B, A>>
}

@JvmName("tupleRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.tupleRight(FF: Functor<F>, arg1: B): StateT<F, S, Tuple2<A, B>> = arrow.data.StateT.functor<F, S>(FF).run {
  this@tupleRight.tupleRight<A, B>(arg1) as arrow.data.StateT<F, S, arrow.core.Tuple2<A, B>>
}

@JvmName("widen")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, B, A : B> Kind<Kind<Kind<ForStateT, F>, S>, A>.widen(FF: Functor<F>): StateT<F, S, B> = arrow.data.StateT.functor<F, S>(FF).run {
  this@widen.widen<B, A>() as arrow.data.StateT<F, S, B>
}

fun <F, S> Companion.functor(FF: Functor<F>): StateTFunctor<F, S> = object : arrow.data.extensions.StateTFunctor<F, S> { override fun FF(): arrow.typeclasses.Functor<F> = FF }