package arrow.data.extensions.statet.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.data.ForStateT
import arrow.data.StateT
import arrow.data.StateT.Companion
import arrow.data.extensions.StateTMonad
import arrow.typeclasses.Monad
import arrow.typeclasses.MonadContinuation
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.flatMap(MF: Monad<F>, arg1: Function1<A, Kind<Kind<Kind<ForStateT, F>, S>, B>>): StateT<F, S, B> = arrow.data.StateT.monad<F, S>(MF).run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.data.StateT<F, S, B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> tailRecM(
    MF: Monad<F>,
    arg0: A,
    arg1: Function1<A, Kind<Kind<Kind<ForStateT, F>, S>, Either<A, B>>>
): StateT<F, S, B> = arrow.data.StateT
   .monad<F, S>(MF)
   .tailRecM<A, B>(arg0, arg1) as arrow.data.StateT<F, S, B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.map(MF: Monad<F>, arg1: Function1<A, B>): StateT<F, S, B> = arrow.data.StateT.monad<F, S>(MF).run {
  this@map.map<A, B>(arg1) as arrow.data.StateT<F, S, B>
}

@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.ap(MF: Monad<F>, arg1: Kind<Kind<Kind<ForStateT, F>, S>, Function1<A, B>>): StateT<F, S, B> = arrow.data.StateT.monad<F, S>(MF).run {
  this@ap.ap<A, B>(arg1) as arrow.data.StateT<F, S, B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> Kind<Kind<Kind<ForStateT, F>, S>, Kind<Kind<Kind<ForStateT, F>, S>, A>>.flatten(MF: Monad<F>): StateT<F, S, A> = arrow.data.StateT.monad<F, S>(MF).run {
  this@flatten.flatten<A>() as arrow.data.StateT<F, S, A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.followedBy(MF: Monad<F>, arg1: Kind<Kind<Kind<ForStateT, F>, S>, B>): StateT<F, S, B> = arrow.data.StateT.monad<F, S>(MF).run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.data.StateT<F, S, B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.followedByEval(MF: Monad<F>, arg1: Eval<Kind<Kind<Kind<ForStateT, F>, S>, B>>): StateT<F, S, B> = arrow.data.StateT.monad<F, S>(MF).run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.data.StateT<F, S, B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.effectM(MF: Monad<F>, arg1: Function1<A, Kind<Kind<Kind<ForStateT, F>, S>, B>>): StateT<F, S, A> = arrow.data.StateT.monad<F, S>(MF).run {
  this@effectM.effectM<A, B>(arg1) as arrow.data.StateT<F, S, A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.forEffect(MF: Monad<F>, arg1: Kind<Kind<Kind<ForStateT, F>, S>, B>): StateT<F, S, A> = arrow.data.StateT.monad<F, S>(MF).run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.data.StateT<F, S, A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.forEffectEval(MF: Monad<F>, arg1: Eval<Kind<Kind<Kind<ForStateT, F>, S>, B>>): StateT<F, S, A> = arrow.data.StateT.monad<F, S>(MF).run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.data.StateT<F, S, A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.mproduct(MF: Monad<F>, arg1: Function1<A, Kind<Kind<Kind<ForStateT, F>, S>, B>>): StateT<F, S, Tuple2<A, B>> = arrow.data.StateT.monad<F, S>(MF).run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.data.StateT<F, S, arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, B> Kind<Kind<Kind<ForStateT, F>, S>, Boolean>.ifM(
    MF: Monad<F>,
    arg1: Function0<Kind<Kind<Kind<ForStateT, F>, S>, B>>,
    arg2: Function0<Kind<Kind<Kind<ForStateT, F>, S>, B>>
): StateT<F, S, B> = arrow.data.StateT.monad<F, S>(MF).run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.data.StateT<F, S, B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, Either<A, B>>.selectM(MF: Monad<F>, arg1: Kind<Kind<Kind<ForStateT, F>, S>, Function1<A, B>>): StateT<F, S, B> = arrow.data.StateT.monad<F, S>(MF).run {
  this@selectM.selectM<A, B>(arg1) as arrow.data.StateT<F, S, B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, Either<A, B>>.select(MF: Monad<F>, arg1: Kind<Kind<Kind<ForStateT, F>, S>, Function1<A, B>>): StateT<F, S, B> = arrow.data.StateT.monad<F, S>(MF).run {
  this@select.select<A, B>(arg1) as arrow.data.StateT<F, S, B>
}

@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> binding(MF: Monad<F>, arg0: suspend MonadContinuation<Kind<Kind<ForStateT, F>, S>, *>.() -> A): StateT<F, S, A> = arrow.data.StateT
   .monad<F, S>(MF)
   .binding<A>(arg0) as arrow.data.StateT<F, S, A>

fun <F, S> Companion.monad(MF: Monad<F>): StateTMonad<F, S> = object : arrow.data.extensions.StateTMonad<F, S> { override fun MF(): arrow.typeclasses.Monad<F> = MF }