package arrow.data.extensions.store.functor

import arrow.Kind
import arrow.core.Tuple2
import arrow.data.ForStore
import arrow.data.Store
import arrow.data.Store.Companion
import arrow.data.extensions.StoreFunctor
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <S, A, B> Kind<Kind<ForStore, S>, A>.map(arg1: Function1<A, B>): Store<S, B> = arrow.data.Store.functor<S>().run {
  this@map.map<A, B>(arg1) as arrow.data.Store<S, B>
}

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <S, A, B> Kind<Kind<ForStore, S>, A>.imap(arg1: Function1<A, B>, arg2: Function1<B, A>): Store<S, B> = arrow.data.Store.functor<S>().run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.Store<S, B>
}

@JvmName("lift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <S, A, B> lift(arg0: Function1<A, B>): Function1<Kind<Kind<ForStore, S>, A>, Kind<Kind<ForStore, S>, B>> = arrow.data.Store
   .functor<S>()
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.data.ForStore, S>, A>, arrow.Kind<arrow.Kind<arrow.data.ForStore, S>, B>>

@JvmName("unit")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <S, A> Kind<Kind<ForStore, S>, A>.unit(): Store<S, Unit> = arrow.data.Store.functor<S>().run {
  this@unit.unit<A>() as arrow.data.Store<S, kotlin.Unit>
}

@JvmName("fproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <S, A, B> Kind<Kind<ForStore, S>, A>.fproduct(arg1: Function1<A, B>): Store<S, Tuple2<A, B>> = arrow.data.Store.functor<S>().run {
  this@fproduct.fproduct<A, B>(arg1) as arrow.data.Store<S, arrow.core.Tuple2<A, B>>
}

@JvmName("as")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <S, A, B> Kind<Kind<ForStore, S>, A>.`as`(arg1: B): Store<S, B> = arrow.data.Store.functor<S>().run {
  this@`as`.`as`<A, B>(arg1) as arrow.data.Store<S, B>
}

@JvmName("tupleLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <S, A, B> Kind<Kind<ForStore, S>, A>.tupleLeft(arg1: B): Store<S, Tuple2<B, A>> = arrow.data.Store.functor<S>().run {
  this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.data.Store<S, arrow.core.Tuple2<B, A>>
}

@JvmName("tupleRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <S, A, B> Kind<Kind<ForStore, S>, A>.tupleRight(arg1: B): Store<S, Tuple2<A, B>> = arrow.data.Store.functor<S>().run {
  this@tupleRight.tupleRight<A, B>(arg1) as arrow.data.Store<S, arrow.core.Tuple2<A, B>>
}

@JvmName("widen")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <S, B, A : B> Kind<Kind<ForStore, S>, A>.widen(): Store<S, B> = arrow.data.Store.functor<S>().run {
  this@widen.widen<B, A>() as arrow.data.Store<S, B>
}

fun <S> Companion.functor(): StoreFunctor<S> = object : arrow.data.extensions.StoreFunctor<S> {  }