package arrow.data.extensions.sum.comonad

import arrow.Kind
import arrow.data.ForSum
import arrow.data.Sum
import arrow.data.Sum.Companion
import arrow.data.extensions.SumComonad
import arrow.typeclasses.Comonad
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("coflatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.coflatMap(
    CF: Comonad<F>,
    CG: Comonad<G>,
    arg1: Function1<Kind<Kind<Kind<ForSum, F>, G>, A>, B>
): Sum<F, G, B> = arrow.data.Sum.comonad<F, G>(CF, CG).run {
  this@coflatMap.coflatMap<A, B>(arg1) as arrow.data.Sum<F, G, B>
}

@JvmName("extract")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForSum, F>, G>, A>.extract(CF: Comonad<F>, CG: Comonad<G>): A = arrow.data.Sum.comonad<F, G>(CF, CG).run {
  this@extract.extract<A>() as A
}

@JvmName("duplicate")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForSum, F>, G>, A>.duplicate(CF: Comonad<F>, CG: Comonad<G>): Sum<F, G, Sum<F, G, A>> = arrow.data.Sum.comonad<F, G>(CF, CG).run {
  this@duplicate.duplicate<A>() as arrow.data.Sum<F, G, arrow.data.Sum<F, G, A>>
}

fun <F, G> Companion.comonad(CF: Comonad<F>, CG: Comonad<G>): SumComonad<F, G> = object : arrow.data.extensions.SumComonad<F, G> { override fun CF(): arrow.typeclasses.Comonad<F> = CF

  override fun CG(): arrow.typeclasses.Comonad<G> = CG }