package arrow.data.extensions.sum.contravariant

import arrow.Kind
import arrow.data.ForSum
import arrow.data.Sum
import arrow.data.Sum.Companion
import arrow.data.extensions.ContravariantSumInstance
import arrow.typeclasses.Contravariant
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("contramap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.contramap(
    CF: Contravariant<F>,
    CG: Contravariant<G>,
    arg1: Function1<B, A>
): Sum<F, G, B> = arrow.data.Sum.contravariant<F, G>(CF, CG).run {
  this@contramap.contramap<A, B>(arg1) as arrow.data.Sum<F, G, B>
}

@JvmName("lift1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> lift(
    CF: Contravariant<F>,
    CG: Contravariant<G>,
    arg0: Function1<A, B>
): Function1<Kind<Kind<Kind<ForSum, F>, G>, B>, Kind<Kind<Kind<ForSum, F>, G>, A>> = arrow.data.Sum
   .contravariant<F, G>(CF, CG)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForSum, F>, G>, B>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForSum, F>, G>, A>>

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.imap(
    CF: Contravariant<F>,
    CG: Contravariant<G>,
    arg1: Function1<A, B>,
    arg2: Function1<B, A>
): Sum<F, G, B> = arrow.data.Sum.contravariant<F, G>(CF, CG).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.Sum<F, G, B>
}

@JvmName("narrow")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B : A> Kind<Kind<Kind<ForSum, F>, G>, A>.narrow(CF: Contravariant<F>, CG: Contravariant<G>): Sum<F, G, B> = arrow.data.Sum.contravariant<F, G>(CF, CG).run {
  this@narrow.narrow<A, B>() as arrow.data.Sum<F, G, B>
}

fun <F, G> Companion.contravariant(CF: Contravariant<F>, CG: Contravariant<G>): ContravariantSumInstance<F, G> = object : arrow.data.extensions.ContravariantSumInstance<F, G> { override fun CF(): arrow.typeclasses.Contravariant<F> = CF

  override fun CG(): arrow.typeclasses.Contravariant<G> = CG }