package arrow.data.extensions.sum.divisible

import arrow.data.Sum
import arrow.data.Sum.Companion
import arrow.data.extensions.DivisibleSumInstance
import arrow.typeclasses.Divisible
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("conquer")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> conquer(DFF: Divisible<F>, DGG: Divisible<G>): Sum<F, G, A> = arrow.data.Sum
   .divisible<F, G>(DFF, DGG)
   .conquer<A>() as arrow.data.Sum<F, G, A>

fun <F, G> Companion.divisible(DFF: Divisible<F>, DGG: Divisible<G>): DivisibleSumInstance<F, G> = object : arrow.data.extensions.DivisibleSumInstance<F, G> { override fun DFF(): arrow.typeclasses.Divisible<F> = DFF

  override fun DGG(): arrow.typeclasses.Divisible<G> = DGG }