package arrow.data.extensions.sum.functor

import arrow.Kind
import arrow.core.Tuple2
import arrow.data.ForSum
import arrow.data.Sum
import arrow.data.Sum.Companion
import arrow.data.extensions.SumFunctor
import arrow.typeclasses.Functor
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.map(
    FF: Functor<F>,
    FG: Functor<G>,
    arg1: Function1<A, B>
): Sum<F, G, B> = arrow.data.Sum.functor<F, G>(FF, FG).run {
  this@map.map<A, B>(arg1) as arrow.data.Sum<F, G, B>
}

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.imap(
    FF: Functor<F>,
    FG: Functor<G>,
    arg1: Function1<A, B>,
    arg2: Function1<B, A>
): Sum<F, G, B> = arrow.data.Sum.functor<F, G>(FF, FG).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.Sum<F, G, B>
}

@JvmName("lift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> lift(
    FF: Functor<F>,
    FG: Functor<G>,
    arg0: Function1<A, B>
): Function1<Kind<Kind<Kind<ForSum, F>, G>, A>, Kind<Kind<Kind<ForSum, F>, G>, B>> = arrow.data.Sum
   .functor<F, G>(FF, FG)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForSum, F>, G>, A>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForSum, F>, G>, B>>

@JvmName("unit")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForSum, F>, G>, A>.unit(FF: Functor<F>, FG: Functor<G>): Sum<F, G, Unit> = arrow.data.Sum.functor<F, G>(FF, FG).run {
  this@unit.unit<A>() as arrow.data.Sum<F, G, kotlin.Unit>
}

@JvmName("fproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.fproduct(
    FF: Functor<F>,
    FG: Functor<G>,
    arg1: Function1<A, B>
): Sum<F, G, Tuple2<A, B>> = arrow.data.Sum.functor<F, G>(FF, FG).run {
  this@fproduct.fproduct<A, B>(arg1) as arrow.data.Sum<F, G, arrow.core.Tuple2<A, B>>
}

@JvmName("as")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.`as`(
    FF: Functor<F>,
    FG: Functor<G>,
    arg1: B
): Sum<F, G, B> = arrow.data.Sum.functor<F, G>(FF, FG).run {
  this@`as`.`as`<A, B>(arg1) as arrow.data.Sum<F, G, B>
}

@JvmName("tupleLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.tupleLeft(
    FF: Functor<F>,
    FG: Functor<G>,
    arg1: B
): Sum<F, G, Tuple2<B, A>> = arrow.data.Sum.functor<F, G>(FF, FG).run {
  this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.data.Sum<F, G, arrow.core.Tuple2<B, A>>
}

@JvmName("tupleRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForSum, F>, G>, A>.tupleRight(
    FF: Functor<F>,
    FG: Functor<G>,
    arg1: B
): Sum<F, G, Tuple2<A, B>> = arrow.data.Sum.functor<F, G>(FF, FG).run {
  this@tupleRight.tupleRight<A, B>(arg1) as arrow.data.Sum<F, G, arrow.core.Tuple2<A, B>>
}

@JvmName("widen")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, B, A : B> Kind<Kind<Kind<ForSum, F>, G>, A>.widen(FF: Functor<F>, FG: Functor<G>): Sum<F, G, B> = arrow.data.Sum.functor<F, G>(FF, FG).run {
  this@widen.widen<B, A>() as arrow.data.Sum<F, G, B>
}

fun <F, G> Companion.functor(FF: Functor<F>, FG: Functor<G>): SumFunctor<F, G> = object : arrow.data.extensions.SumFunctor<F, G> { override fun FF(): arrow.typeclasses.Functor<F> = FF

  override fun FG(): arrow.typeclasses.Functor<G> = FG }