package arrow.data.extensions.validated.applicative

import arrow.Kind
import arrow.core.Eval
import arrow.core.Tuple10
import arrow.core.Tuple2
import arrow.core.Tuple3
import arrow.core.Tuple4
import arrow.core.Tuple5
import arrow.core.Tuple6
import arrow.core.Tuple7
import arrow.core.Tuple8
import arrow.core.Tuple9
import arrow.data.ForValidated
import arrow.data.Validated
import arrow.data.Validated.Companion
import arrow.data.extensions.ValidatedApplicative
import arrow.typeclasses.Semigroup
import java.math.BigDecimal
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("just1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> A.just(SE: Semigroup<E>): Validated<E, A> = arrow.data.Validated.applicative<E>(SE).run {
  this@just.just<A>() as arrow.data.Validated<E, A>
}

@JvmName("unit")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E> unit(SE: Semigroup<E>): Validated<E, Unit> = arrow.data.Validated
   .applicative<E>(SE)
   .unit() as arrow.data.Validated<E, kotlin.Unit>

@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.ap(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, Function1<A, B>>): Validated<E, B> = arrow.data.Validated.applicative<E>(SE).run {
  this@ap.ap<A, B>(arg1) as arrow.data.Validated<E, B>
}

@JvmName("product")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.product(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, B>): Validated<E, Tuple2<A, B>> = arrow.data.Validated.applicative<E>(SE).run {
  this@product.product<A, B>(arg1) as arrow.data.Validated<E, arrow.core.Tuple2<A, B>>
}

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.map(SE: Semigroup<E>, arg1: Function1<A, B>): Validated<E, B> = arrow.data.Validated.applicative<E>(SE).run {
  this@map.map<A, B>(arg1) as arrow.data.Validated<E, B>
}

@JvmName("map2")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, Z> Kind<Kind<ForValidated, E>, A>.map2(
    SE: Semigroup<E>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Function1<Tuple2<A, B>, Z>
): Validated<E, Z> = arrow.data.Validated.applicative<E>(SE).run {
  this@map2.map2<A, B, Z>(arg1, arg2) as arrow.data.Validated<E, Z>
}

@JvmName("map2Eval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, Z> Kind<Kind<ForValidated, E>, A>.map2Eval(
    SE: Semigroup<E>,
    arg1: Eval<Kind<Kind<ForValidated, E>, B>>,
    arg2: Function1<Tuple2<A, B>, Z>
): Eval<Kind<Kind<ForValidated, E>, Z>> = arrow.data.Validated.applicative<E>(SE).run {
  this@map2Eval.map2Eval<A, B, Z>(arg1, arg2) as arrow.core.Eval<arrow.Kind<arrow.Kind<arrow.data.ForValidated, E>, Z>>
}

@JvmName("product1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, Z> Kind<Kind<ForValidated, E>, Tuple2<A, B>>.product(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, Z>): Validated<E, Tuple3<A, B, Z>> = arrow.data.Validated.applicative<E>(SE).run {
  this@product.product<A, B, Z>(arg1) as arrow.data.Validated<E, arrow.core.Tuple3<A, B, Z>>
}

@JvmName("product2")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, Z> Kind<Kind<ForValidated, E>, Tuple3<A, B, C>>.product(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, Z>): Validated<E, Tuple4<A, B, C, Z>> = arrow.data.Validated.applicative<E>(SE).run {
  this@product.product<A, B, C, Z>(arg1) as arrow.data.Validated<E, arrow.core.Tuple4<A, B, C, Z>>
}

@JvmName("product3")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, Z> Kind<Kind<ForValidated, E>, Tuple4<A, B, C, D>>.product(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, Z>): Validated<E, Tuple5<A, B, C, D, Z>> = arrow.data.Validated.applicative<E>(SE).run {
  this@product.product<A, B, C, D, Z>(arg1) as arrow.data.Validated<E, arrow.core.Tuple5<A, B, C, D, Z>>
}

@JvmName("product4")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, Z> Kind<Kind<ForValidated, E>, Tuple5<A, B, C, D, E>>.product(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, Z>): Validated<E, Tuple6<A, B, C, D, E, Z>> = arrow.data.Validated.applicative<E>(SE).run {
  this@product.product<A, B, C, D, E, Z>(arg1) as arrow.data.Validated<E, arrow.core.Tuple6<A, B, C, D, E, Z>>
}

@JvmName("product5")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, Z> Kind<Kind<ForValidated, E>, Tuple6<A, B, C, D, E, FF>>.product(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, Z>): Validated<E, Tuple7<A, B, C, D, E, FF, Z>> = arrow.data.Validated.applicative<E>(SE).run {
  this@product.product<A, B, C, D, E, FF, Z>(arg1) as arrow.data.Validated<E, arrow.core.Tuple7<A, B, C, D, E, FF, Z>>
}

@JvmName("product6")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, Z> Kind<Kind<ForValidated, E>, Tuple7<A, B, C, D, E, FF, G>>.product(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, Z>): Validated<E, Tuple8<A, B, C, D, E, FF, G, Z>> = arrow.data.Validated.applicative<E>(SE).run {
  this@product.product<A, B, C, D, E, FF, G, Z>(arg1) as arrow.data.Validated<E, arrow.core.Tuple8<A, B, C, D, E, FF, G, Z>>
}

@JvmName("product7")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, H, Z> Kind<Kind<ForValidated, E>, Tuple8<A, B, C, D, E, FF, G, H>>.product(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, Z>): Validated<E, Tuple9<A, B, C, D, E, FF, G, H, Z>> = arrow.data.Validated.applicative<E>(SE).run {
  this@product.product<A, B, C, D, E, FF, G, H, Z>(arg1) as arrow.data.Validated<E, arrow.core.Tuple9<A, B, C, D, E, FF, G, H, Z>>
}

@JvmName("product8")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, H, I, Z> Kind<Kind<ForValidated, E>, Tuple9<A, B, C, D, E, FF, G, H, I>>.product(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, Z>): Validated<E, Tuple10<A, B, C, D, E, FF, G, H, I, Z>> = arrow.data.Validated.applicative<E>(SE).run {
  this@product.product<A, B, C, D, E, FF, G, H, I, Z>(arg1) as arrow.data.Validated<E, arrow.core.Tuple10<A, B, C, D, E, FF, G, H, I, Z>>
}

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> tupled(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>
): Validated<E, Tuple2<A, B>> = arrow.data.Validated
   .applicative<E>(SE)
   .tupled<A, B>(arg0, arg1) as arrow.data.Validated<E, arrow.core.Tuple2<A, B>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C> tupled(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>
): Validated<E, Tuple3<A, B, C>> = arrow.data.Validated
   .applicative<E>(SE)
   .tupled<A, B, C>(arg0, arg1, arg2) as arrow.data.Validated<E, arrow.core.Tuple3<A, B, C>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D> tupled(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>
): Validated<E, Tuple4<A, B, C, D>> = arrow.data.Validated
   .applicative<E>(SE)
   .tupled<A, B, C, D>(arg0, arg1, arg2, arg3) as arrow.data.Validated<E, arrow.core.Tuple4<A, B, C, D>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D> tupled(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>
): Validated<E, Tuple5<A, B, C, D, E>> = arrow.data.Validated
   .applicative<E>(SE)
   .tupled<A, B, C, D, E>(arg0, arg1, arg2, arg3, arg4) as arrow.data.Validated<E, arrow.core.Tuple5<A, B, C, D, E>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF> tupled(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>
): Validated<E, Tuple6<A, B, C, D, E, FF>> = arrow.data.Validated
   .applicative<E>(SE)
   .tupled<A, B, C, D, E, FF>(arg0, arg1, arg2, arg3, arg4, arg5) as arrow.data.Validated<E, arrow.core.Tuple6<A, B, C, D, E, FF>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G> tupled(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>,
    arg6: Kind<Kind<ForValidated, E>, G>
): Validated<E, Tuple7<A, B, C, D, E, FF, G>> = arrow.data.Validated
   .applicative<E>(SE)
   .tupled<A, B, C, D, E, FF, G>(arg0, arg1, arg2, arg3, arg4, arg5, arg6) as arrow.data.Validated<E, arrow.core.Tuple7<A, B, C, D, E, FF, G>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, H> tupled(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>,
    arg6: Kind<Kind<ForValidated, E>, G>,
    arg7: Kind<Kind<ForValidated, E>, H>
): Validated<E, Tuple8<A, B, C, D, E, FF, G, H>> = arrow.data.Validated
   .applicative<E>(SE)
   .tupled<A, B, C, D, E, FF, G, H>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7) as arrow.data.Validated<E, arrow.core.Tuple8<A, B, C, D, E, FF, G, H>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, H, I> tupled(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>,
    arg6: Kind<Kind<ForValidated, E>, G>,
    arg7: Kind<Kind<ForValidated, E>, H>,
    arg8: Kind<Kind<ForValidated, E>, I>
): Validated<E, Tuple9<A, B, C, D, E, FF, G, H, I>> = arrow.data.Validated
   .applicative<E>(SE)
   .tupled<A, B, C, D, E, FF, G, H, I>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) as arrow.data.Validated<E, arrow.core.Tuple9<A, B, C, D, E, FF, G, H, I>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, H, I, J> tupled(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>,
    arg6: Kind<Kind<ForValidated, E>, G>,
    arg7: Kind<Kind<ForValidated, E>, H>,
    arg8: Kind<Kind<ForValidated, E>, I>,
    arg9: Kind<Kind<ForValidated, E>, J>
): Validated<E, Tuple10<A, B, C, D, E, FF, G, H, I, J>> = arrow.data.Validated
   .applicative<E>(SE)
   .tupled<A, B, C, D, E, FF, G, H, I, J>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) as arrow.data.Validated<E, arrow.core.Tuple10<A, B, C, D, E, FF, G, H, I, J>>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, Z> map(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Function1<Tuple2<A, B>, Z>
): Validated<E, Z> = arrow.data.Validated
   .applicative<E>(SE)
   .map<A, B, Z>(arg0, arg1, arg2) as arrow.data.Validated<E, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, Z> map(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Function1<Tuple3<A, B, C>, Z>
): Validated<E, Z> = arrow.data.Validated
   .applicative<E>(SE)
   .map<A, B, C, Z>(arg0, arg1, arg2, arg3) as arrow.data.Validated<E, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, Z> map(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Function1<Tuple4<A, B, C, D>, Z>
): Validated<E, Z> = arrow.data.Validated
   .applicative<E>(SE)
   .map<A, B, C, D, Z>(arg0, arg1, arg2, arg3, arg4) as arrow.data.Validated<E, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, Z> map(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Function1<Tuple5<A, B, C, D, E>, Z>
): Validated<E, Z> = arrow.data.Validated
   .applicative<E>(SE)
   .map<A, B, C, D, E, Z>(arg0, arg1, arg2, arg3, arg4, arg5) as arrow.data.Validated<E, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, Z> map(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>,
    arg6: Function1<Tuple6<A, B, C, D, E, FF>, Z>
): Validated<E, Z> = arrow.data.Validated
   .applicative<E>(SE)
   .map<A, B, C, D, E, FF, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6) as arrow.data.Validated<E, Z>

@JvmName("plus")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E> Kind<Kind<ForValidated, E>, BigDecimal>.plus(SE: Semigroup<E>, arg1: Kind<Kind<ForValidated, E>, BigDecimal>): Validated<E, BigDecimal> = arrow.data.Validated.applicative<E>(SE).run {
  this@plus.plus(arg1) as arrow.data.Validated<E, java.math.BigDecimal>
}

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, Z> map(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>,
    arg6: Kind<Kind<ForValidated, E>, G>,
    arg7: Function1<Tuple7<A, B, C, D, E, FF, G>, Z>
): Validated<E, Z> = arrow.data.Validated
   .applicative<E>(SE)
   .map<A, B, C, D, E, FF, G, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7) as arrow.data.Validated<E, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, H, Z> map(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>,
    arg6: Kind<Kind<ForValidated, E>, G>,
    arg7: Kind<Kind<ForValidated, E>, H>,
    arg8: Function1<Tuple8<A, B, C, D, E, FF, G, H>, Z>
): Validated<E, Z> = arrow.data.Validated
   .applicative<E>(SE)
   .map<A, B, C, D, E, FF, G, H, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) as arrow.data.Validated<E, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, H, I, Z> map(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>,
    arg6: Kind<Kind<ForValidated, E>, G>,
    arg7: Kind<Kind<ForValidated, E>, H>,
    arg8: Kind<Kind<ForValidated, E>, I>,
    arg9: Function1<Tuple9<A, B, C, D, E, FF, G, H, I>, Z>
): Validated<E, Z> = arrow.data.Validated
   .applicative<E>(SE)
   .map<A, B, C, D, E, FF, G, H, I, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) as arrow.data.Validated<E, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B, C, D, FF, G, H, I, J, Z> map(
    SE: Semigroup<E>,
    arg0: Kind<Kind<ForValidated, E>, A>,
    arg1: Kind<Kind<ForValidated, E>, B>,
    arg2: Kind<Kind<ForValidated, E>, C>,
    arg3: Kind<Kind<ForValidated, E>, D>,
    arg4: Kind<Kind<ForValidated, E>, E>,
    arg5: Kind<Kind<ForValidated, E>, FF>,
    arg6: Kind<Kind<ForValidated, E>, G>,
    arg7: Kind<Kind<ForValidated, E>, H>,
    arg8: Kind<Kind<ForValidated, E>, I>,
    arg9: Kind<Kind<ForValidated, E>, J>,
    arg10: Function1<Tuple10<A, B, C, D, E, FF, G, H, I, J>, Z>
): Validated<E, Z> = arrow.data.Validated
   .applicative<E>(SE)
   .map<A, B, C, D, E, FF, G, H, I, J, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) as arrow.data.Validated<E, Z>

fun <E> Companion.applicative(SE: Semigroup<E>): ValidatedApplicative<E> = object : arrow.data.extensions.ValidatedApplicative<E> { override fun SE(): arrow.typeclasses.Semigroup<E> = SE }