package arrow.data.extensions.validated.applicativeError

import arrow.Kind
import arrow.core.Either
import arrow.core.ForOption
import arrow.core.ForTry
import arrow.data.ForValidated
import arrow.data.Validated
import arrow.data.Validated.Companion
import arrow.data.extensions.ValidatedApplicativeError
import arrow.typeclasses.ApplicativeError
import arrow.typeclasses.Semigroup
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("handleErrorWith")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.handleErrorWith(SE: Semigroup<E>, arg1: Function1<E, Kind<Kind<ForValidated, E>, A>>): Validated<E, A> = arrow.data.Validated.applicativeError<E>(SE).run {
  this@handleErrorWith.handleErrorWith<A>(arg1) as arrow.data.Validated<E, A>
}

@JvmName("raiseError1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> E.raiseError(SE: Semigroup<E>): Validated<E, A> = arrow.data.Validated.applicativeError<E>(SE).run {
  this@raiseError.raiseError<A>() as arrow.data.Validated<E, A>
}

@JvmName("fromOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> Kind<ForOption, A>.fromOption(SE: Semigroup<E>, arg1: Function0<E>): Validated<E, A> = arrow.data.Validated.applicativeError<E>(SE).run {
  this@fromOption.fromOption<A>(arg1) as arrow.data.Validated<E, A>
}

@JvmName("fromEither")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, EE> Either<EE, A>.fromEither(SE: Semigroup<E>, arg1: Function1<EE, E>): Validated<E, A> = arrow.data.Validated.applicativeError<E>(SE).run {
  this@fromEither.fromEither<A, EE>(arg1) as arrow.data.Validated<E, A>
}

@JvmName("fromTry")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> Kind<ForTry, A>.fromTry(SE: Semigroup<E>, arg1: Function1<Throwable, E>): Validated<E, A> = arrow.data.Validated.applicativeError<E>(SE).run {
  this@fromTry.fromTry<A>(arg1) as arrow.data.Validated<E, A>
}

@JvmName("handleError")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.handleError(SE: Semigroup<E>, arg1: Function1<E, A>): Validated<E, A> = arrow.data.Validated.applicativeError<E>(SE).run {
  this@handleError.handleError<A>(arg1) as arrow.data.Validated<E, A>
}

@JvmName("attempt")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.attempt(SE: Semigroup<E>): Validated<E, Either<E, A>> = arrow.data.Validated.applicativeError<E>(SE).run {
  this@attempt.attempt<A>() as arrow.data.Validated<E, arrow.core.Either<E, A>>
}

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> catch(
    SE: Semigroup<E>,
    arg0: Function1<Throwable, E>,
    arg1: Function0<A>
): Validated<E, A> = arrow.data.Validated
   .applicativeError<E>(SE)
   .catch<A>(arg0, arg1) as arrow.data.Validated<E, A>

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> ApplicativeError<Kind<ForValidated, E>, Throwable>.catch(SE: Semigroup<E>, arg1: Function0<A>): Validated<E, A> = arrow.data.Validated.applicativeError<E>(SE).run {
  this@catch.catch<A>(arg1) as arrow.data.Validated<E, A>
}

fun <E> Companion.applicativeError(SE: Semigroup<E>): ValidatedApplicativeError<E> = object : arrow.data.extensions.ValidatedApplicativeError<E> { override fun SE(): arrow.typeclasses.Semigroup<E> = SE }