package arrow.data.extensions.validated.functor

import arrow.Kind
import arrow.core.Tuple2
import arrow.data.ForValidated
import arrow.data.Validated
import arrow.data.Validated.Companion
import arrow.data.extensions.ValidatedFunctor
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.map(arg1: Function1<A, B>): Validated<E, B> = arrow.data.Validated.functor<E>().run {
  this@map.map<A, B>(arg1) as arrow.data.Validated<E, B>
}

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.imap(arg1: Function1<A, B>, arg2: Function1<B, A>): Validated<E, B> = arrow.data.Validated.functor<E>().run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.Validated<E, B>
}

@JvmName("lift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> lift(arg0: Function1<A, B>): Function1<Kind<Kind<ForValidated, E>, A>, Kind<Kind<ForValidated, E>, B>> = arrow.data.Validated
   .functor<E>()
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.data.ForValidated, E>, A>, arrow.Kind<arrow.Kind<arrow.data.ForValidated, E>, B>>

@JvmName("unit")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.unit(): Validated<E, Unit> = arrow.data.Validated.functor<E>().run {
  this@unit.unit<A>() as arrow.data.Validated<E, kotlin.Unit>
}

@JvmName("fproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.fproduct(arg1: Function1<A, B>): Validated<E, Tuple2<A, B>> = arrow.data.Validated.functor<E>().run {
  this@fproduct.fproduct<A, B>(arg1) as arrow.data.Validated<E, arrow.core.Tuple2<A, B>>
}

@JvmName("as")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.`as`(arg1: B): Validated<E, B> = arrow.data.Validated.functor<E>().run {
  this@`as`.`as`<A, B>(arg1) as arrow.data.Validated<E, B>
}

@JvmName("tupleLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.tupleLeft(arg1: B): Validated<E, Tuple2<B, A>> = arrow.data.Validated.functor<E>().run {
  this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.data.Validated<E, arrow.core.Tuple2<B, A>>
}

@JvmName("tupleRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.tupleRight(arg1: B): Validated<E, Tuple2<A, B>> = arrow.data.Validated.functor<E>().run {
  this@tupleRight.tupleRight<A, B>(arg1) as arrow.data.Validated<E, arrow.core.Tuple2<A, B>>
}

@JvmName("widen")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, B, A : B> Kind<Kind<ForValidated, E>, A>.widen(): Validated<E, B> = arrow.data.Validated.functor<E>().run {
  this@widen.widen<B, A>() as arrow.data.Validated<E, B>
}

fun <E> Companion.functor(): ValidatedFunctor<E> = object : arrow.data.extensions.ValidatedFunctor<E> {  }