package arrow.data.extensions.validated.traverse

import arrow.Kind
import arrow.data.ForValidated
import arrow.data.Validated
import arrow.data.Validated.Companion
import arrow.data.extensions.ValidatedTraverse
import arrow.typeclasses.Applicative
import arrow.typeclasses.Monad
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("traverse")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, G, A, B> Kind<Kind<ForValidated, E>, A>.traverse(arg1: Applicative<G>, arg2: Function1<A, Kind<G, B>>): Kind<G, Kind<Kind<ForValidated, E>, B>> = arrow.data.Validated.traverse<E>().run {
  this@traverse.traverse<G, A, B>(arg1, arg2) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.data.ForValidated, E>, B>>
}

@JvmName("sequence")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, G, A> Kind<Kind<ForValidated, E>, Kind<G, A>>.sequence(arg1: Applicative<G>): Kind<G, Kind<Kind<ForValidated, E>, A>> = arrow.data.Validated.traverse<E>().run {
  this@sequence.sequence<G, A>(arg1) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.data.ForValidated, E>, A>>
}

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.map(arg1: Function1<A, B>): Validated<E, B> = arrow.data.Validated.traverse<E>().run {
  this@map.map<A, B>(arg1) as arrow.data.Validated<E, B>
}

@JvmName("flatTraverse")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <E, G, A, B> Kind<Kind<ForValidated, E>, A>.flatTraverse(
    arg1: Monad<Kind<ForValidated, E>>,
    arg2: Applicative<G>,
    arg3: Function1<A, Kind<G, Kind<Kind<ForValidated, E>, B>>>
): Kind<G, Kind<Kind<ForValidated, E>, B>> = arrow.data.Validated.traverse<E>().run {
  this@flatTraverse.flatTraverse<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.data.ForValidated, E>, B>>
}

fun <E> Companion.traverse(): ValidatedTraverse<E> = object : arrow.data.extensions.ValidatedTraverse<E> {  }