package arrow.data.extensions.writert.applicativeError

import arrow.Kind
import arrow.core.Either
import arrow.core.ForOption
import arrow.core.ForTry
import arrow.data.ForWriterT
import arrow.data.WriterT
import arrow.data.WriterT.Companion
import arrow.data.extensions.WriterTApplicativeError
import arrow.typeclasses.ApplicativeError
import arrow.typeclasses.Monoid
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("handleErrorWith")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, E, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.handleErrorWith(
    AE: ApplicativeError<F, E>,
    MM: Monoid<W>,
    arg1: Function1<E, Kind<Kind<Kind<ForWriterT, F>, W>, A>>
): WriterT<F, W, A> = arrow.data.WriterT.applicativeError<F, W, E>(AE, MM).run {
  this@handleErrorWith.handleErrorWith<A>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("raiseError1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, E, A> E.raiseError(AE: ApplicativeError<F, E>, MM: Monoid<W>): WriterT<F, W, A> = arrow.data.WriterT.applicativeError<F, W, E>(AE, MM).run {
  this@raiseError.raiseError<A>() as arrow.data.WriterT<F, W, A>
}

@JvmName("fromOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, E, A> Kind<ForOption, A>.fromOption(
    AE: ApplicativeError<F, E>,
    MM: Monoid<W>,
    arg1: Function0<E>
): WriterT<F, W, A> = arrow.data.WriterT.applicativeError<F, W, E>(AE, MM).run {
  this@fromOption.fromOption<A>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("fromEither")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, E, A, EE> Either<EE, A>.fromEither(
    AE: ApplicativeError<F, E>,
    MM: Monoid<W>,
    arg1: Function1<EE, E>
): WriterT<F, W, A> = arrow.data.WriterT.applicativeError<F, W, E>(AE, MM).run {
  this@fromEither.fromEither<A, EE>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("fromTry")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, E, A> Kind<ForTry, A>.fromTry(
    AE: ApplicativeError<F, E>,
    MM: Monoid<W>,
    arg1: Function1<Throwable, E>
): WriterT<F, W, A> = arrow.data.WriterT.applicativeError<F, W, E>(AE, MM).run {
  this@fromTry.fromTry<A>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("handleError")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, E, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.handleError(
    AE: ApplicativeError<F, E>,
    MM: Monoid<W>,
    arg1: Function1<E, A>
): WriterT<F, W, A> = arrow.data.WriterT.applicativeError<F, W, E>(AE, MM).run {
  this@handleError.handleError<A>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("attempt")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, E, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.attempt(AE: ApplicativeError<F, E>, MM: Monoid<W>): WriterT<F, W, Either<E, A>> = arrow.data.WriterT.applicativeError<F, W, E>(AE, MM).run {
  this@attempt.attempt<A>() as arrow.data.WriterT<F, W, arrow.core.Either<E, A>>
}

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, E, A> catch(
    AE: ApplicativeError<F, E>,
    MM: Monoid<W>,
    arg0: Function1<Throwable, E>,
    arg1: Function0<A>
): WriterT<F, W, A> = arrow.data.WriterT
   .applicativeError<F, W, E>(AE, MM)
   .catch<A>(arg0, arg1) as arrow.data.WriterT<F, W, A>

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, E, A> ApplicativeError<Kind<Kind<ForWriterT, F>, W>, Throwable>.catch(
    AE: ApplicativeError<F, E>,
    MM: Monoid<W>,
    arg1: Function0<A>
): WriterT<F, W, A> = arrow.data.WriterT.applicativeError<F, W, E>(AE, MM).run {
  this@catch.catch<A>(arg1) as arrow.data.WriterT<F, W, A>
}

fun <F, W, E> Companion.applicativeError(AE: ApplicativeError<F, E>, MM: Monoid<W>): WriterTApplicativeError<F, W, E> = object : arrow.data.extensions.WriterTApplicativeError<F, W, E> { override fun AE(): arrow.typeclasses.ApplicativeError<F, E> = AE

  override fun MM(): arrow.typeclasses.Monoid<W> = MM }