package arrow.data.extensions.writert.functor

import arrow.Kind
import arrow.core.Tuple2
import arrow.data.ForWriterT
import arrow.data.WriterT
import arrow.data.WriterT.Companion
import arrow.data.extensions.WriterTFunctor
import arrow.typeclasses.Functor
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.map(FF: Functor<F>, arg1: Function1<A, B>): WriterT<F, W, B> = arrow.data.WriterT.functor<F, W>(FF).run {
  this@map.map<A, B>(arg1) as arrow.data.WriterT<F, W, B>
}

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.imap(
    FF: Functor<F>,
    arg1: Function1<A, B>,
    arg2: Function1<B, A>
): WriterT<F, W, B> = arrow.data.WriterT.functor<F, W>(FF).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.WriterT<F, W, B>
}

@JvmName("lift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> lift(FF: Functor<F>, arg0: Function1<A, B>): Function1<Kind<Kind<Kind<ForWriterT, F>, W>, A>, Kind<Kind<Kind<ForWriterT, F>, W>, B>> = arrow.data.WriterT
   .functor<F, W>(FF)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForWriterT, F>, W>, A>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForWriterT, F>, W>, B>>

@JvmName("unit")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.unit(FF: Functor<F>): WriterT<F, W, Unit> = arrow.data.WriterT.functor<F, W>(FF).run {
  this@unit.unit<A>() as arrow.data.WriterT<F, W, kotlin.Unit>
}

@JvmName("fproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.fproduct(FF: Functor<F>, arg1: Function1<A, B>): WriterT<F, W, Tuple2<A, B>> = arrow.data.WriterT.functor<F, W>(FF).run {
  this@fproduct.fproduct<A, B>(arg1) as arrow.data.WriterT<F, W, arrow.core.Tuple2<A, B>>
}

@JvmName("as")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.`as`(FF: Functor<F>, arg1: B): WriterT<F, W, B> = arrow.data.WriterT.functor<F, W>(FF).run {
  this@`as`.`as`<A, B>(arg1) as arrow.data.WriterT<F, W, B>
}

@JvmName("tupleLeft")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.tupleLeft(FF: Functor<F>, arg1: B): WriterT<F, W, Tuple2<B, A>> = arrow.data.WriterT.functor<F, W>(FF).run {
  this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.data.WriterT<F, W, arrow.core.Tuple2<B, A>>
}

@JvmName("tupleRight")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.tupleRight(FF: Functor<F>, arg1: B): WriterT<F, W, Tuple2<A, B>> = arrow.data.WriterT.functor<F, W>(FF).run {
  this@tupleRight.tupleRight<A, B>(arg1) as arrow.data.WriterT<F, W, arrow.core.Tuple2<A, B>>
}

@JvmName("widen")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, B, A : B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.widen(FF: Functor<F>): WriterT<F, W, B> = arrow.data.WriterT.functor<F, W>(FF).run {
  this@widen.widen<B, A>() as arrow.data.WriterT<F, W, B>
}

fun <F, W> Companion.functor(FF: Functor<F>): WriterTFunctor<F, W> = object : arrow.data.extensions.WriterTFunctor<F, W> { override fun FF(): arrow.typeclasses.Functor<F> = FF }