package arrow.data.extensions.writert.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.data.ForWriterT
import arrow.data.WriterT
import arrow.data.WriterT.Companion
import arrow.data.extensions.WriterTMonad
import arrow.typeclasses.Monad
import arrow.typeclasses.MonadContinuation
import arrow.typeclasses.Monoid
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.flatMap(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Function1<A, Kind<Kind<Kind<ForWriterT, F>, W>, B>>
): WriterT<F, W, B> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.data.WriterT<F, W, B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> tailRecM(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg0: A,
    arg1: Function1<A, Kind<Kind<Kind<ForWriterT, F>, W>, Either<A, B>>>
): WriterT<F, W, B> = arrow.data.WriterT
   .monad<F, W>(MF, MM)
   .tailRecM<A, B>(arg0, arg1) as arrow.data.WriterT<F, W, B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.map(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Function1<A, B>
): WriterT<F, W, B> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@map.map<A, B>(arg1) as arrow.data.WriterT<F, W, B>
}

@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.ap(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Kind<Kind<Kind<ForWriterT, F>, W>, Function1<A, B>>
): WriterT<F, W, B> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@ap.ap<A, B>(arg1) as arrow.data.WriterT<F, W, B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> Kind<Kind<Kind<ForWriterT, F>, W>, Kind<Kind<Kind<ForWriterT, F>, W>, A>>.flatten(MF: Monad<F>, MM: Monoid<W>): WriterT<F, W, A> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@flatten.flatten<A>() as arrow.data.WriterT<F, W, A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.followedBy(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Kind<Kind<Kind<ForWriterT, F>, W>, B>
): WriterT<F, W, B> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.data.WriterT<F, W, B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.followedByEval(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Eval<Kind<Kind<Kind<ForWriterT, F>, W>, B>>
): WriterT<F, W, B> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.data.WriterT<F, W, B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.effectM(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Function1<A, Kind<Kind<Kind<ForWriterT, F>, W>, B>>
): WriterT<F, W, A> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@effectM.effectM<A, B>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.forEffect(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Kind<Kind<Kind<ForWriterT, F>, W>, B>
): WriterT<F, W, A> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.forEffectEval(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Eval<Kind<Kind<Kind<ForWriterT, F>, W>, B>>
): WriterT<F, W, A> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.mproduct(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Function1<A, Kind<Kind<Kind<ForWriterT, F>, W>, B>>
): WriterT<F, W, Tuple2<A, B>> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.data.WriterT<F, W, arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, B> Kind<Kind<Kind<ForWriterT, F>, W>, Boolean>.ifM(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Function0<Kind<Kind<Kind<ForWriterT, F>, W>, B>>,
    arg2: Function0<Kind<Kind<Kind<ForWriterT, F>, W>, B>>
): WriterT<F, W, B> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.data.WriterT<F, W, B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, Either<A, B>>.selectM(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Kind<Kind<Kind<ForWriterT, F>, W>, Function1<A, B>>
): WriterT<F, W, B> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@selectM.selectM<A, B>(arg1) as arrow.data.WriterT<F, W, B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, Either<A, B>>.select(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg1: Kind<Kind<Kind<ForWriterT, F>, W>, Function1<A, B>>
): WriterT<F, W, B> = arrow.data.WriterT.monad<F, W>(MF, MM).run {
  this@select.select<A, B>(arg1) as arrow.data.WriterT<F, W, B>
}

@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> binding(
    MF: Monad<F>,
    MM: Monoid<W>,
    arg0: suspend MonadContinuation<Kind<Kind<ForWriterT, F>, W>, *>.() -> A
): WriterT<F, W, A> = arrow.data.WriterT
   .monad<F, W>(MF, MM)
   .binding<A>(arg0) as arrow.data.WriterT<F, W, A>

fun <F, W> Companion.monad(MF: Monad<F>, MM: Monoid<W>): WriterTMonad<F, W> = object : arrow.data.extensions.WriterTMonad<F, W> { override fun MF(): arrow.typeclasses.Monad<F> = MF

  override fun MM(): arrow.typeclasses.Monoid<W> = MM }