package arrow.fx.mtl.eithert.async

import arrow.Kind
import arrow.core.Either
import arrow.fx.mtl.EitherTAsync
import arrow.fx.typeclasses.Async
import arrow.mtl.EitherT
import arrow.mtl.EitherT.Companion
import arrow.mtl.ForEitherT
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.coroutines.CoroutineContext
import kotlin.jvm.JvmName

@JvmName("asyncF")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> asyncF(ASF: Async<F>, arg0: Function1<Function1<Either<Throwable, A>, Unit>,
    Kind<Kind<Kind<ForEitherT, L>, F>, Unit>>): EitherT<L, F, A> = arrow.mtl.EitherT
   .async<L, F>(ASF)
   .asyncF<A>(arg0) as arrow.mtl.EitherT<L, F, A>

@JvmName("continueOn")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> Kind<Kind<Kind<ForEitherT, L>, F>, A>.continueOn(ASF: Async<F>,
    arg1: CoroutineContext): EitherT<L, F, A> = arrow.mtl.EitherT.async<L, F>(ASF).run {
  this@continueOn.continueOn<A>(arg1) as arrow.mtl.EitherT<L, F, A>
}

@JvmName("later")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> later(
  ASF: Async<F>,
  arg0: CoroutineContext,
  arg1: Function0<A>
): EitherT<L, F, A> = arrow.mtl.EitherT
   .async<L, F>(ASF)
   .later<A>(arg0, arg1) as arrow.mtl.EitherT<L, F, A>

@JvmName("effect")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> effect(ASF: Async<F>, arg0: suspend () -> A): EitherT<L, F, A> = arrow.mtl.EitherT
   .async<L, F>(ASF)
   .effect<A>(arg0) as arrow.mtl.EitherT<L, F, A>

@JvmName("effect")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> effect(
  ASF: Async<F>,
  arg0: CoroutineContext,
  arg1: suspend () -> A
): EitherT<L, F, A> = arrow.mtl.EitherT
   .async<L, F>(ASF)
   .effect<A>(arg0, arg1) as arrow.mtl.EitherT<L, F, A>

@JvmName("defer")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> defer(
  ASF: Async<F>,
  arg0: CoroutineContext,
  arg1: Function0<Kind<Kind<Kind<ForEitherT, L>, F>, A>>
): EitherT<L, F, A> = arrow.mtl.EitherT
   .async<L, F>(ASF)
   .defer<A>(arg0, arg1) as arrow.mtl.EitherT<L, F, A>

@JvmName("laterOrRaise")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> laterOrRaise(
  ASF: Async<F>,
  arg0: CoroutineContext,
  arg1: Function0<Either<Throwable, A>>
): EitherT<L, F, A> = arrow.mtl.EitherT
   .async<L, F>(ASF)
   .laterOrRaise<A>(arg0, arg1) as arrow.mtl.EitherT<L, F, A>

@JvmName("shift")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F> CoroutineContext.shift(ASF: Async<F>): EitherT<L, F, Unit> = arrow.mtl.EitherT.async<L,
    F>(ASF).run {
  this@shift.shift() as arrow.mtl.EitherT<L, F, kotlin.Unit>
}

@JvmName("never")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> never(ASF: Async<F>): EitherT<L, F, A> = arrow.mtl.EitherT
   .async<L, F>(ASF)
   .never<A>() as arrow.mtl.EitherT<L, F, A>

@JvmName("effectMap")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A, B> Kind<Kind<Kind<ForEitherT, L>, F>, A>.effectMap(ASF: Async<F>, arg1: suspend (A) ->
    B): EitherT<L, F, B> = arrow.mtl.EitherT.async<L, F>(ASF).run {
  this@effectMap.effectMap<A, B>(arg1) as arrow.mtl.EitherT<L, F, B>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <L, F> Companion.async(ASF: Async<F>): EitherTAsync<L, F> = object :
    arrow.fx.mtl.EitherTAsync<L, F> { override fun ASF(): arrow.fx.typeclasses.Async<F> = ASF }