package arrow.fx.mtl.eithert.bracket

import arrow.Kind
import arrow.fx.mtl.EitherTBracket
import arrow.fx.typeclasses.ExitCase
import arrow.fx.typeclasses.MonadDefer
import arrow.mtl.EitherT
import arrow.mtl.EitherT.Companion
import arrow.mtl.ForEitherT
import kotlin.Function1
import kotlin.Function2
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("bracketCase")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A, B> Kind<Kind<Kind<ForEitherT, L>, F>, A>.bracketCase(
  MDF: MonadDefer<F>,
  arg1: Function2<A, ExitCase<Throwable>, Kind<Kind<Kind<ForEitherT, L>, F>, Unit>>,
  arg2: Function1<A, Kind<Kind<Kind<ForEitherT, L>, F>, B>>
): EitherT<L, F, B> = arrow.mtl.EitherT.bracket<L, F>(MDF).run {
  this@bracketCase.bracketCase<A, B>(arg1, arg2) as arrow.mtl.EitherT<L, F, B>
}

@JvmName("bracket")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A, B> Kind<Kind<Kind<ForEitherT, L>, F>, A>.bracket(
  MDF: MonadDefer<F>,
  arg1: Function1<A, Kind<Kind<Kind<ForEitherT, L>, F>, Unit>>,
  arg2: Function1<A, Kind<Kind<Kind<ForEitherT, L>, F>, B>>
): EitherT<L, F, B> = arrow.mtl.EitherT.bracket<L, F>(MDF).run {
  this@bracket.bracket<A, B>(arg1, arg2) as arrow.mtl.EitherT<L, F, B>
}

@JvmName("uncancellable")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> Kind<Kind<Kind<ForEitherT, L>, F>, A>.uncancellable(MDF: MonadDefer<F>): EitherT<L, F,
    A> = arrow.mtl.EitherT.bracket<L, F>(MDF).run {
  this@uncancellable.uncancellable<A>() as arrow.mtl.EitherT<L, F, A>
}

@JvmName("uncancelable")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> Kind<Kind<Kind<ForEitherT, L>, F>, A>.uncancelable(MDF: MonadDefer<F>): EitherT<L, F,
    A> = arrow.mtl.EitherT.bracket<L, F>(MDF).run {
  this@uncancelable.uncancelable<A>() as arrow.mtl.EitherT<L, F, A>
}

@JvmName("guarantee")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> Kind<Kind<Kind<ForEitherT, L>, F>, A>.guarantee(MDF: MonadDefer<F>,
    arg1: Kind<Kind<Kind<ForEitherT, L>, F>, Unit>): EitherT<L, F, A> = arrow.mtl.EitherT.bracket<L,
    F>(MDF).run {
  this@guarantee.guarantee<A>(arg1) as arrow.mtl.EitherT<L, F, A>
}

@JvmName("guaranteeCase")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> Kind<Kind<Kind<ForEitherT, L>, F>, A>.guaranteeCase(MDF: MonadDefer<F>,
    arg1: Function1<ExitCase<Throwable>, Kind<Kind<Kind<ForEitherT, L>, F>, Unit>>): EitherT<L, F,
    A> = arrow.mtl.EitherT.bracket<L, F>(MDF).run {
  this@guaranteeCase.guaranteeCase<A>(arg1) as arrow.mtl.EitherT<L, F, A>
}

@JvmName("onCancel")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> Kind<Kind<Kind<ForEitherT, L>, F>, A>.onCancel(MDF: MonadDefer<F>,
    arg1: Kind<Kind<Kind<ForEitherT, L>, F>, Unit>): EitherT<L, F, A> = arrow.mtl.EitherT.bracket<L,
    F>(MDF).run {
  this@onCancel.onCancel<A>(arg1) as arrow.mtl.EitherT<L, F, A>
}

@JvmName("onError")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, F, A> Kind<Kind<Kind<ForEitherT, L>, F>, A>.onError(MDF: MonadDefer<F>,
    arg1: Function1<Throwable, Kind<Kind<Kind<ForEitherT, L>, F>, Unit>>): EitherT<L, F, A> =
    arrow.mtl.EitherT.bracket<L, F>(MDF).run {
  this@onError.onError<A>(arg1) as arrow.mtl.EitherT<L, F, A>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <L, F> Companion.bracket(MDF: MonadDefer<F>): EitherTBracket<L, F> = object :
    arrow.fx.mtl.EitherTBracket<L, F> { override fun MDF(): arrow.fx.typeclasses.MonadDefer<F> = MDF
    }