package arrow.fx.mtl.kleisli.async

import arrow.Kind
import arrow.core.Either
import arrow.fx.mtl.KleisliAsync
import arrow.fx.typeclasses.Async
import arrow.mtl.ForKleisli
import arrow.mtl.Kleisli
import arrow.mtl.Kleisli.Companion
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.coroutines.CoroutineContext
import kotlin.jvm.JvmName

@JvmName("asyncF")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, A> asyncF(ASF: Async<F>, arg0: Function1<Function1<Either<Throwable, A>, Unit>,
    Kind<Kind<Kind<ForKleisli, D>, F>, Unit>>): Kleisli<D, F, A> = arrow.mtl.Kleisli
   .async<D, F>(ASF)
   .asyncF<A>(arg0) as arrow.mtl.Kleisli<D, F, A>

@JvmName("continueOn")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, A> Kind<Kind<Kind<ForKleisli, D>, F>, A>.continueOn(ASF: Async<F>,
    arg1: CoroutineContext): Kleisli<D, F, A> = arrow.mtl.Kleisli.async<D, F>(ASF).run {
  this@continueOn.continueOn<A>(arg1) as arrow.mtl.Kleisli<D, F, A>
}

@JvmName("later")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, A> later(
  ASF: Async<F>,
  arg0: CoroutineContext,
  arg1: Function0<A>
): Kleisli<D, F, A> = arrow.mtl.Kleisli
   .async<D, F>(ASF)
   .later<A>(arg0, arg1) as arrow.mtl.Kleisli<D, F, A>

@JvmName("effect")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, A> effect(ASF: Async<F>, arg0: suspend () -> A): Kleisli<D, F, A> = arrow.mtl.Kleisli
   .async<D, F>(ASF)
   .effect<A>(arg0) as arrow.mtl.Kleisli<D, F, A>

@JvmName("effect")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, A> effect(
  ASF: Async<F>,
  arg0: CoroutineContext,
  arg1: suspend () -> A
): Kleisli<D, F, A> = arrow.mtl.Kleisli
   .async<D, F>(ASF)
   .effect<A>(arg0, arg1) as arrow.mtl.Kleisli<D, F, A>

@JvmName("defer")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, A> defer(
  ASF: Async<F>,
  arg0: CoroutineContext,
  arg1: Function0<Kind<Kind<Kind<ForKleisli, D>, F>, A>>
): Kleisli<D, F, A> = arrow.mtl.Kleisli
   .async<D, F>(ASF)
   .defer<A>(arg0, arg1) as arrow.mtl.Kleisli<D, F, A>

@JvmName("laterOrRaise")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, A> laterOrRaise(
  ASF: Async<F>,
  arg0: CoroutineContext,
  arg1: Function0<Either<Throwable, A>>
): Kleisli<D, F, A> = arrow.mtl.Kleisli
   .async<D, F>(ASF)
   .laterOrRaise<A>(arg0, arg1) as arrow.mtl.Kleisli<D, F, A>

@JvmName("shift")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F> CoroutineContext.shift(ASF: Async<F>): Kleisli<D, F, Unit> = arrow.mtl.Kleisli.async<D,
    F>(ASF).run {
  this@shift.shift() as arrow.mtl.Kleisli<D, F, kotlin.Unit>
}

@JvmName("never")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, A> never(ASF: Async<F>): Kleisli<D, F, A> = arrow.mtl.Kleisli
   .async<D, F>(ASF)
   .never<A>() as arrow.mtl.Kleisli<D, F, A>

@JvmName("effectMap")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, A, B> Kind<Kind<Kind<ForKleisli, D>, F>, A>.effectMap(ASF: Async<F>, arg1: suspend (A) ->
    B): Kleisli<D, F, B> = arrow.mtl.Kleisli.async<D, F>(ASF).run {
  this@effectMap.effectMap<A, B>(arg1) as arrow.mtl.Kleisli<D, F, B>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <D, F> Companion.async(ASF: Async<F>): KleisliAsync<D, F> = object :
    arrow.fx.mtl.KleisliAsync<D, F> { override fun ASF(): arrow.fx.typeclasses.Async<F> = ASF }