package arrow.fx.mtl.kleisli.bracket

import arrow.Kind
import arrow.fx.mtl.KleisliBracket
import arrow.fx.typeclasses.Bracket
import arrow.fx.typeclasses.ExitCase
import arrow.mtl.ForKleisli
import arrow.mtl.Kleisli
import arrow.mtl.Kleisli.Companion
import kotlin.Function1
import kotlin.Function2
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("bracketCase")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, E, A, B> Kind<Kind<Kind<ForKleisli, D>, F>, A>.bracketCase(
  BF: Bracket<F, E>,
  arg1: Function2<A, ExitCase<E>, Kind<Kind<Kind<ForKleisli, D>, F>, Unit>>,
  arg2: Function1<A, Kind<Kind<Kind<ForKleisli, D>, F>, B>>
): Kleisli<D, F, B> = arrow.mtl.Kleisli.bracket<D, F, E>(BF).run {
  this@bracketCase.bracketCase<A, B>(arg1, arg2) as arrow.mtl.Kleisli<D, F, B>
}

@JvmName("bracket")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, E, A, B> Kind<Kind<Kind<ForKleisli, D>, F>, A>.bracket(
  BF: Bracket<F, E>,
  arg1: Function1<A, Kind<Kind<Kind<ForKleisli, D>, F>, Unit>>,
  arg2: Function1<A, Kind<Kind<Kind<ForKleisli, D>, F>, B>>
): Kleisli<D, F, B> = arrow.mtl.Kleisli.bracket<D, F, E>(BF).run {
  this@bracket.bracket<A, B>(arg1, arg2) as arrow.mtl.Kleisli<D, F, B>
}

@JvmName("uncancellable")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, E, A> Kind<Kind<Kind<ForKleisli, D>, F>, A>.uncancellable(BF: Bracket<F, E>): Kleisli<D,
    F, A> = arrow.mtl.Kleisli.bracket<D, F, E>(BF).run {
  this@uncancellable.uncancellable<A>() as arrow.mtl.Kleisli<D, F, A>
}

@JvmName("uncancelable")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, E, A> Kind<Kind<Kind<ForKleisli, D>, F>, A>.uncancelable(BF: Bracket<F, E>): Kleisli<D,
    F, A> = arrow.mtl.Kleisli.bracket<D, F, E>(BF).run {
  this@uncancelable.uncancelable<A>() as arrow.mtl.Kleisli<D, F, A>
}

@JvmName("guarantee")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, E, A> Kind<Kind<Kind<ForKleisli, D>, F>, A>.guarantee(BF: Bracket<F, E>,
    arg1: Kind<Kind<Kind<ForKleisli, D>, F>, Unit>): Kleisli<D, F, A> = arrow.mtl.Kleisli.bracket<D,
    F, E>(BF).run {
  this@guarantee.guarantee<A>(arg1) as arrow.mtl.Kleisli<D, F, A>
}

@JvmName("guaranteeCase")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, E, A> Kind<Kind<Kind<ForKleisli, D>, F>, A>.guaranteeCase(BF: Bracket<F, E>,
    arg1: Function1<ExitCase<E>, Kind<Kind<Kind<ForKleisli, D>, F>, Unit>>): Kleisli<D, F, A> =
    arrow.mtl.Kleisli.bracket<D, F, E>(BF).run {
  this@guaranteeCase.guaranteeCase<A>(arg1) as arrow.mtl.Kleisli<D, F, A>
}

@JvmName("onCancel")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, E, A> Kind<Kind<Kind<ForKleisli, D>, F>, A>.onCancel(BF: Bracket<F, E>,
    arg1: Kind<Kind<Kind<ForKleisli, D>, F>, Unit>): Kleisli<D, F, A> = arrow.mtl.Kleisli.bracket<D,
    F, E>(BF).run {
  this@onCancel.onCancel<A>(arg1) as arrow.mtl.Kleisli<D, F, A>
}

@JvmName("onError")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <D, F, E, A> Kind<Kind<Kind<ForKleisli, D>, F>, A>.onError(BF: Bracket<F, E>, arg1: Function1<E,
    Kind<Kind<Kind<ForKleisli, D>, F>, Unit>>): Kleisli<D, F, A> = arrow.mtl.Kleisli.bracket<D, F,
    E>(BF).run {
  this@onError.onError<A>(arg1) as arrow.mtl.Kleisli<D, F, A>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <D, F, E> Companion.bracket(BF: Bracket<F, E>): KleisliBracket<D, F, E> = object :
    arrow.fx.mtl.KleisliBracket<D, F, E> { override fun BF(): arrow.fx.typeclasses.Bracket<F, E> =
    BF }