package arrow.fx.mtl.optiont.bracket

import arrow.Kind
import arrow.fx.mtl.OptionTBracket
import arrow.fx.typeclasses.ExitCase
import arrow.fx.typeclasses.MonadDefer
import arrow.mtl.ForOptionT
import arrow.mtl.OptionT
import arrow.mtl.OptionT.Companion
import kotlin.Function1
import kotlin.Function2
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("bracketCase")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.bracketCase(
  MD: MonadDefer<F>,
  arg1: Function2<A, ExitCase<Throwable>, Kind<Kind<ForOptionT, F>, Unit>>,
  arg2: Function1<A, Kind<Kind<ForOptionT, F>, B>>
): OptionT<F, B> = arrow.mtl.OptionT.bracket<F>(MD).run {
  this@bracketCase.bracketCase<A, B>(arg1, arg2) as arrow.mtl.OptionT<F, B>
}

@JvmName("bracket")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.bracket(
  MD: MonadDefer<F>,
  arg1: Function1<A, Kind<Kind<ForOptionT, F>, Unit>>,
  arg2: Function1<A, Kind<Kind<ForOptionT, F>, B>>
): OptionT<F, B> = arrow.mtl.OptionT.bracket<F>(MD).run {
  this@bracket.bracket<A, B>(arg1, arg2) as arrow.mtl.OptionT<F, B>
}

@JvmName("uncancellable")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.uncancellable(MD: MonadDefer<F>): OptionT<F, A> =
    arrow.mtl.OptionT.bracket<F>(MD).run {
  this@uncancellable.uncancellable<A>() as arrow.mtl.OptionT<F, A>
}

@JvmName("uncancelable")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.uncancelable(MD: MonadDefer<F>): OptionT<F, A> =
    arrow.mtl.OptionT.bracket<F>(MD).run {
  this@uncancelable.uncancelable<A>() as arrow.mtl.OptionT<F, A>
}

@JvmName("guarantee")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.guarantee(MD: MonadDefer<F>, arg1: Kind<Kind<ForOptionT, F>,
    Unit>): OptionT<F, A> = arrow.mtl.OptionT.bracket<F>(MD).run {
  this@guarantee.guarantee<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("guaranteeCase")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.guaranteeCase(MD: MonadDefer<F>,
    arg1: Function1<ExitCase<Throwable>, Kind<Kind<ForOptionT, F>, Unit>>): OptionT<F, A> =
    arrow.mtl.OptionT.bracket<F>(MD).run {
  this@guaranteeCase.guaranteeCase<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("onCancel")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.onCancel(MD: MonadDefer<F>, arg1: Kind<Kind<ForOptionT, F>,
    Unit>): OptionT<F, A> = arrow.mtl.OptionT.bracket<F>(MD).run {
  this@onCancel.onCancel<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("onError")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.onError(MD: MonadDefer<F>, arg1: Function1<Throwable,
    Kind<Kind<ForOptionT, F>, Unit>>): OptionT<F, A> = arrow.mtl.OptionT.bracket<F>(MD).run {
  this@onError.onError<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <F> Companion.bracket(MD: MonadDefer<F>): OptionTBracket<F> = object :
    arrow.fx.mtl.OptionTBracket<F> { override fun MD(): arrow.fx.typeclasses.MonadDefer<F> = MD }