package arrow.fx.mtl.statet.bracket

import arrow.Kind
import arrow.fx.mtl.StateTBracket
import arrow.fx.typeclasses.ExitCase
import arrow.fx.typeclasses.MonadDefer
import arrow.mtl.ForStateT
import arrow.mtl.StateT
import arrow.mtl.StateT.Companion
import kotlin.Function1
import kotlin.Function2
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("bracketCase")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <S, F, A, B> Kind<Kind<Kind<ForStateT, S>, F>, A>.bracketCase(
  MD: MonadDefer<F>,
  arg1: Function2<A, ExitCase<Throwable>, Kind<Kind<Kind<ForStateT, S>, F>, Unit>>,
  arg2: Function1<A, Kind<Kind<Kind<ForStateT, S>, F>, B>>
): StateT<S, F, B> = arrow.mtl.StateT.bracket<S, F>(MD).run {
  this@bracketCase.bracketCase<A, B>(arg1, arg2) as arrow.mtl.StateT<S, F, B>
}

@JvmName("bracket")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <S, F, A, B> Kind<Kind<Kind<ForStateT, S>, F>, A>.bracket(
  MD: MonadDefer<F>,
  arg1: Function1<A, Kind<Kind<Kind<ForStateT, S>, F>, Unit>>,
  arg2: Function1<A, Kind<Kind<Kind<ForStateT, S>, F>, B>>
): StateT<S, F, B> = arrow.mtl.StateT.bracket<S, F>(MD).run {
  this@bracket.bracket<A, B>(arg1, arg2) as arrow.mtl.StateT<S, F, B>
}

@JvmName("uncancellable")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <S, F, A> Kind<Kind<Kind<ForStateT, S>, F>, A>.uncancellable(MD: MonadDefer<F>): StateT<S, F, A>
    = arrow.mtl.StateT.bracket<S, F>(MD).run {
  this@uncancellable.uncancellable<A>() as arrow.mtl.StateT<S, F, A>
}

@JvmName("uncancelable")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <S, F, A> Kind<Kind<Kind<ForStateT, S>, F>, A>.uncancelable(MD: MonadDefer<F>): StateT<S, F, A>
    = arrow.mtl.StateT.bracket<S, F>(MD).run {
  this@uncancelable.uncancelable<A>() as arrow.mtl.StateT<S, F, A>
}

@JvmName("guarantee")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <S, F, A> Kind<Kind<Kind<ForStateT, S>, F>, A>.guarantee(MD: MonadDefer<F>,
    arg1: Kind<Kind<Kind<ForStateT, S>, F>, Unit>): StateT<S, F, A> = arrow.mtl.StateT.bracket<S,
    F>(MD).run {
  this@guarantee.guarantee<A>(arg1) as arrow.mtl.StateT<S, F, A>
}

@JvmName("guaranteeCase")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <S, F, A> Kind<Kind<Kind<ForStateT, S>, F>, A>.guaranteeCase(MD: MonadDefer<F>,
    arg1: Function1<ExitCase<Throwable>, Kind<Kind<Kind<ForStateT, S>, F>, Unit>>): StateT<S, F, A>
    = arrow.mtl.StateT.bracket<S, F>(MD).run {
  this@guaranteeCase.guaranteeCase<A>(arg1) as arrow.mtl.StateT<S, F, A>
}

@JvmName("onCancel")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <S, F, A> Kind<Kind<Kind<ForStateT, S>, F>, A>.onCancel(MD: MonadDefer<F>,
    arg1: Kind<Kind<Kind<ForStateT, S>, F>, Unit>): StateT<S, F, A> = arrow.mtl.StateT.bracket<S,
    F>(MD).run {
  this@onCancel.onCancel<A>(arg1) as arrow.mtl.StateT<S, F, A>
}

@JvmName("onError")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <S, F, A> Kind<Kind<Kind<ForStateT, S>, F>, A>.onError(MD: MonadDefer<F>,
    arg1: Function1<Throwable, Kind<Kind<Kind<ForStateT, S>, F>, Unit>>): StateT<S, F, A> =
    arrow.mtl.StateT.bracket<S, F>(MD).run {
  this@onError.onError<A>(arg1) as arrow.mtl.StateT<S, F, A>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <S, F> Companion.bracket(MD: MonadDefer<F>): StateTBracket<S, F> = object :
    arrow.fx.mtl.StateTBracket<S, F> { override fun MD(): arrow.fx.typeclasses.MonadDefer<F> = MD }