/*
 * Decompiled with CFR 0.152.
 */
package arrow.fx.internal;

import arrow.core.Either;
import arrow.core.None;
import arrow.core.Option;
import arrow.core.Some;
import arrow.core.internal.AtomicBooleanW;
import arrow.fx.ForIO;
import arrow.fx.IO;
import arrow.fx.KindConnection;
import arrow.fx.internal.OneShotLatch;
import arrow.fx.internal.Platform;
import arrow.fx.typeclasses.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PublishedApi;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002&'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0011\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013J1\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00170\u0015\"\u0004\b\u0000\u0010\u00162\u0014\b\u0004\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0086\bJH\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00170\u0015\"\u0004\b\u0000\u0010\u00162\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c2\u0014\b\u0004\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0080\b\u00a2\u0006\u0002\b\u001dJ\u0019\u0010\u001e\u001a\u00020\u00172\u000e\b\u0004\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fH\u0086\bJ(\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00160!\"\u0004\b\u0000\u0010\u00162\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00160#2\u0006\u0010$\u001a\u00020%R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Larrow/fx/internal/Platform;", "", "()V", "_trampoline", "Ljava/lang/ThreadLocal;", "Larrow/fx/internal/Platform$TrampolineExecutor;", "_trampoline$annotations", "get_trampoline", "()Ljava/lang/ThreadLocal;", "maxStackDepthSize", "", "underlying", "Ljava/util/concurrent/Executor;", "composeErrors", "", "first", "rest", "", "(Ljava/lang/Throwable;[Ljava/lang/Throwable;)Ljava/lang/Throwable;", "", "onceOnly", "Lkotlin/Function1;", "A", "", "f", "conn", "Larrow/fx/KindConnection;", "Larrow/fx/ForIO;", "Larrow/fx/IOConnection;", "onceOnly$arrow_fx", "trampoline", "Lkotlin/Function0;", "unsafeResync", "Larrow/core/Option;", "ioa", "Larrow/fx/IO;", "limit", "Larrow/fx/typeclasses/Duration;", "ArrayStack", "TrampolineExecutor", "arrow-fx"})
public final class Platform {
    public static final int maxStackDepthSize = 127;
    private static final Executor underlying;
    @NotNull
    private static final ThreadLocal<TrampolineExecutor> _trampoline;
    public static final Platform INSTANCE;

    @NotNull
    public final <A> Function1<A, Unit> onceOnly(@NotNull Function1<? super A, Unit> f) {
        int $i$f$onceOnly = 0;
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        AtomicBooleanW wasCalled = new AtomicBooleanW(false);
        return new Function1<A, Unit>(wasCalled, f){
            final /* synthetic */ AtomicBooleanW $wasCalled;
            final /* synthetic */ Function1 $f;

            public final void invoke(A a) {
                if (!this.$wasCalled.getAndSet(true)) {
                    this.$f.invoke(a);
                }
            }
            {
                this.$wasCalled = atomicBooleanW;
                this.$f = function1;
                super(1);
            }
        };
    }

    @NotNull
    public final <A> Function1<A, Unit> onceOnly$arrow_fx(@NotNull KindConnection<ForIO> conn, @NotNull Function1<? super A, Unit> f) {
        int $i$f$onceOnly$arrow_fx = 0;
        Intrinsics.checkParameterIsNotNull(conn, (String)"conn");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        AtomicBooleanW wasCalled = new AtomicBooleanW(false);
        return new Function1<A, Unit>(wasCalled, conn, f){
            final /* synthetic */ AtomicBooleanW $wasCalled;
            final /* synthetic */ KindConnection $conn;
            final /* synthetic */ Function1 $f;

            public final void invoke(A a) {
                if (!this.$wasCalled.getAndSet(true)) {
                    this.$conn.pop();
                    this.$f.invoke(a);
                }
            }
            {
                this.$wasCalled = atomicBooleanW;
                this.$conn = kindConnection;
                this.$f = function1;
                super(1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <A> Option<A> unsafeResync(@NotNull IO<? extends A> ioa, @NotNull Duration limit) {
        Option option;
        void ref;
        Intrinsics.checkParameterIsNotNull(ioa, (String)"ioa");
        Intrinsics.checkParameterIsNotNull((Object)limit, (String)"limit");
        OneShotLatch latch = new OneShotLatch();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ioa.unsafeRunAsync((Function1)new Function1<Either<? extends Throwable, ? extends A>, Unit>((Ref.ObjectRef)ref, latch){
            final /* synthetic */ Ref.ObjectRef $ref;
            final /* synthetic */ OneShotLatch $latch;

            public final void invoke(@NotNull Either<? extends Throwable, ? extends A> a) {
                Intrinsics.checkParameterIsNotNull(a, (String)"a");
                this.$ref.element = a;
                this.$latch.releaseShared(1);
            }
            {
                this.$ref = objectRef;
                this.$latch = oneShotLatch;
                super(1);
            }
        });
        if (Intrinsics.areEqual((Object)limit, (Object)Duration.Companion.getINFINITE())) {
            latch.acquireSharedInterruptibly(1);
        } else {
            latch.tryAcquireSharedNanos(1, limit.getNanoseconds());
        }
        Either eitherRef = (Either)ref.element;
        if (eitherRef == null) {
            option = (Option)None.INSTANCE;
        } else {
            if (eitherRef instanceof Either.Left) {
                throw (Throwable)((Either.Left)eitherRef).getA();
            }
            if (eitherRef instanceof Either.Right) {
                option = (Option)new Some(((Either.Right)eitherRef).getB());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return option;
    }

    @NotNull
    public final Throwable composeErrors(@NotNull Throwable first, Throwable ... rest) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)rest, (String)"rest");
        Throwable[] $this$forEach$iv = rest;
        boolean $i$f$forEach = false;
        Throwable[] throwableArray = $this$forEach$iv;
        int n = throwableArray.length;
        for (int i = 0; i < n; ++i) {
            Throwable element$iv;
            Throwable it = element$iv = throwableArray[i];
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)first) ^ true)) continue;
            first.addSuppressed(it);
        }
        return first;
    }

    @NotNull
    public final Throwable composeErrors(@NotNull Throwable first, @NotNull List<? extends Throwable> rest) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull(rest, (String)"rest");
        Iterable $this$forEach$iv = rest;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Throwable it = (Throwable)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)first) ^ true)) continue;
            first.addSuppressed(it);
        }
        return first;
    }

    public final void trampoline(@NotNull Function0<Unit> f) {
        int $i$f$trampoline = 0;
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        this.get_trampoline().get().execute(new Runnable(f){
            final /* synthetic */ Function0 $f;

            public final void run() {
                this.$f.invoke();
            }
            {
                this.$f = function0;
            }
        });
    }

    @PublishedApi
    public static /* synthetic */ void _trampoline$annotations() {
    }

    @NotNull
    public final ThreadLocal<TrampolineExecutor> get_trampoline() {
        return _trampoline;
    }

    private Platform() {
    }

    static {
        Platform platform;
        INSTANCE = platform = new Platform();
        underlying = underlying.1.INSTANCE;
        _trampoline = new ThreadLocal<TrampolineExecutor>(){

            @NotNull
            protected TrampolineExecutor initialValue() {
                return new TrampolineExecutor(Platform.access$getUnderlying$p(Platform.INSTANCE));
            }
        };
    }

    public static final /* synthetic */ Executor access$getUnderlying$p(Platform $this) {
        Platform platform = $this;
        return underlying;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\r\u0010\u0010\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010\u0016\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0014\u0010\u0016\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fR\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Larrow/fx/internal/Platform$ArrayStack;", "A", "", "()V", "array", "", "[Ljava/lang/Object;", "index", "", "initialArray", "modulo", "isEmpty", "", "isNotEmpty", "iteratorReversed", "", "pop", "()Ljava/lang/Object;", "push", "", "a", "(Ljava/lang/Object;)V", "pushAll", "stack", "seq", "", "cursor", "arrow-fx"})
    public static final class ArrayStack<A> {
        private final Object[] initialArray = new Object[8];
        private final int modulo = 7;
        private Object[] array = this.initialArray;
        private int index;

        public final boolean isEmpty() {
            return this.index == 0 && ArraysKt.getOrNull((Object[])this.array, (int)0) == null;
        }

        public final void push(A a) {
            if (this.index == this.modulo) {
                Object[] newArray = new Object[8];
                newArray[0] = this.array;
                this.array = newArray;
                this.index = 1;
            } else {
                ++this.index;
            }
            this.array[this.index] = a;
        }

        public final void pushAll(@NotNull Iterator<? extends A> cursor) {
            Intrinsics.checkParameterIsNotNull(cursor, (String)"cursor");
            while (cursor.hasNext()) {
                this.push(cursor.next());
            }
        }

        public final void pushAll(@NotNull Iterable<? extends A> seq) {
            Intrinsics.checkParameterIsNotNull(seq, (String)"seq");
            this.pushAll(seq.iterator());
        }

        public final void pushAll(@NotNull ArrayStack<A> stack) {
            Intrinsics.checkParameterIsNotNull(stack, (String)"stack");
            this.pushAll(stack.iteratorReversed());
        }

        @Nullable
        public final A pop() {
            if (this.index == 0) {
                if (ArraysKt.getOrNull((Object[])this.array, (int)0) != null) {
                    Object object = this.array[0];
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                    }
                    this.array = (Object[])object;
                    this.index = this.modulo;
                } else {
                    return null;
                }
            }
            Object result = this.array[this.index];
            this.array[this.index] = null;
            --this.index;
            return (A)result;
        }

        @NotNull
        public final Iterator<A> iteratorReversed() {
            return new Iterator<A>(this){
                private Object[] array;
                private int index;
                final /* synthetic */ ArrayStack this$0;

                public boolean hasNext() {
                    return this.index > 0 || ArraysKt.getOrNull((Object[])this.array, (int)0) != null;
                }

                public A next() {
                    if (this.index == 0) {
                        Object object = this.array[0];
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                        }
                        this.array = (Object[])object;
                        this.index = ArrayStack.access$getModulo$p(this.this$0);
                    }
                    Object result = this.array[this.index];
                    --this.index;
                    return (A)result;
                }
                {
                    this.this$0 = $outer;
                    this.array = ArrayStack.access$getArray$p($outer);
                    this.index = ArrayStack.access$getIndex$p($outer);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        public final boolean isNotEmpty() {
            return !this.isEmpty();
        }

        public static final /* synthetic */ int access$getModulo$p(ArrayStack $this) {
            return $this.modulo;
        }

        public static final /* synthetic */ Object[] access$getArray$p(ArrayStack $this) {
            return $this.array;
        }

        public static final /* synthetic */ void access$setArray$p(ArrayStack $this, Object[] objectArray) {
            $this.array = objectArray;
        }

        public static final /* synthetic */ int access$getIndex$p(ArrayStack $this) {
            return $this.index;
        }

        public static final /* synthetic */ void access$setIndex$p(ArrayStack $this, int n) {
            $this.index = n;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u000f\u001a\u00020\rH\u0002J\u0011\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007H\u0082\u0010J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Larrow/fx/internal/Platform$TrampolineExecutor;", "", "underlying", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "immediateQueue", "Larrow/fx/internal/Platform$ArrayStack;", "Ljava/lang/Runnable;", "getUnderlying", "()Ljava/util/concurrent/Executor;", "withinLoop", "", "execute", "", "runnable", "forkTheRest", "immediateLoop", "task", "startLoop", "arrow-fx"})
    @PublishedApi
    public static final class TrampolineExecutor {
        private ArrayStack<Runnable> immediateQueue;
        private volatile boolean withinLoop;
        @NotNull
        private final Executor underlying;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void startLoop(Runnable runnable) {
            this.withinLoop = true;
            try {
                this.immediateLoop(runnable);
            }
            finally {
                this.withinLoop = false;
            }
        }

        public final void execute(@NotNull Runnable runnable) {
            Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
            if (!this.withinLoop) {
                this.startLoop(runnable);
            } else {
                this.immediateQueue.push(runnable);
            }
        }

        private final void forkTheRest() {
            Runnable head = this.immediateQueue.pop();
            if (head != null) {
                ArrayStack<Runnable> rest = this.immediateQueue;
                this.immediateQueue = new ArrayStack();
                @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"arrow/fx/internal/Platform$TrampolineExecutor$forkTheRest$ResumeRun", "Ljava/lang/Runnable;", "head", "rest", "Larrow/fx/internal/Platform$ArrayStack;", "(Larrow/fx/internal/Platform$TrampolineExecutor;Ljava/lang/Runnable;Larrow/fx/internal/Platform$ArrayStack;)V", "getHead", "()Ljava/lang/Runnable;", "getRest", "()Larrow/fx/internal/Platform$ArrayStack;", "run", "", "arrow-fx"})
                public final class ResumeRun
                implements Runnable {
                    @NotNull
                    private final Runnable head;
                    @NotNull
                    private final ArrayStack<Runnable> rest;
                    final /* synthetic */ TrampolineExecutor this$0;

                    public void run() {
                        TrampolineExecutor.access$getImmediateQueue$p(this.this$0).pushAll(this.rest);
                        TrampolineExecutor.access$immediateLoop(this.this$0, this.head);
                    }

                    @NotNull
                    public final Runnable getHead() {
                        return this.head;
                    }

                    @NotNull
                    public final ArrayStack<Runnable> getRest() {
                        return this.rest;
                    }

                    public ResumeRun(@NotNull TrampolineExecutor $outer, @NotNull Runnable head, ArrayStack<Runnable> rest) {
                        Intrinsics.checkParameterIsNotNull((Object)head, (String)"head");
                        Intrinsics.checkParameterIsNotNull(rest, (String)"rest");
                        this.this$0 = $outer;
                        this.head = head;
                        this.rest = rest;
                    }
                }
                this.underlying.execute(new ResumeRun(this, head, rest));
            }
        }

        private final void immediateLoop(Runnable task) {
            while (true) {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    this.forkTheRest();
                }
                Runnable next = this.immediateQueue.pop();
                if (next == null) break;
                task = next;
            }
        }

        @NotNull
        public final Executor getUnderlying() {
            return this.underlying;
        }

        public TrampolineExecutor(@NotNull Executor underlying2) {
            Intrinsics.checkParameterIsNotNull((Object)underlying2, (String)"underlying");
            this.underlying = underlying2;
            this.immediateQueue = new ArrayStack();
        }

        public static final /* synthetic */ ArrayStack access$getImmediateQueue$p(TrampolineExecutor $this) {
            return $this.immediateQueue;
        }

        public static final /* synthetic */ void access$setImmediateQueue$p(TrampolineExecutor $this, ArrayStack arrayStack) {
            $this.immediateQueue = arrayStack;
        }

        public static final /* synthetic */ void access$immediateLoop(TrampolineExecutor $this, Runnable task) {
            $this.immediateLoop(task);
        }
    }
}

