/*
 * Decompiled with CFR 0.152.
 */
package arrow.fx.internal;

import arrow.core.None;
import arrow.core.Option;
import arrow.core.Some;
import arrow.core.Tuple2;
import arrow.core.TupleNKt;
import arrow.core.extensions.list.foldable.ListKFoldableKt;
import arrow.fx.internal.IQueueKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="The IO datatype and it's related type classes will disappear in Arrow 0.13.0. All useful operations are offered directly over suspend functions by Arrow Fx Coroutines. https://arrow-kt.io/docs/fx/async/")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 -*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001-B#\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0006J)\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u000b\u001a\u00028\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0002\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u000fJ\u001e\u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u000f0\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J\u001a\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001cJ \u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001cJ \u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001cJ\u001a\u0010\u001f\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001cJ\u000b\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u000b\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u0006\u0010#\u001a\u00020\u001aJ\u0006\u0010$\u001a\u00020\u001aJ\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0096\u0002J\u0006\u0010'\u001a\u00020\u0014J\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J\b\u0010*\u001a\u00020+H\u0016J\u001d\u0010\"\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002H\u0002\u00a2\u0006\u0002\u0010,J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0004\"\u0004\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006."}, d2={"Larrow/fx/internal/IQueue;", "A", "", "lIn", "", "lOut", "(Ljava/util/List;Ljava/util/List;)V", "getLIn", "()Ljava/util/List;", "getLOut", "cons", "a", "l", "(Ljava/lang/Object;Ljava/util/List;)Ljava/util/List;", "dequeue", "Larrow/core/Tuple2;", "dequeueOption", "Larrow/core/Option;", "drop", "n", "", "enqueue", "elem", "(Ljava/lang/Object;)Larrow/fx/internal/IQueue;", "elems", "exists", "", "p", "Lkotlin/Function1;", "filter", "filterNot", "forAll", "front", "()Ljava/lang/Object;", "head", "isEmpty", "isNotEmpty", "iterator", "", "length", "tail", "toList", "toString", "", "(Ljava/lang/Iterable;)Ljava/lang/Object;", "Companion", "arrow-fx"})
public final class IQueue<A>
implements Iterable<A>,
KMappedMarker {
    @NotNull
    private final List<A> lIn;
    @NotNull
    private final List<A> lOut;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final <A> A head(Iterable<? extends A> $this$head) {
        return (A)CollectionsKt.first($this$head);
    }

    private final <A> List<A> tail(Iterable<? extends A> $this$tail) {
        return CollectionsKt.drop($this$tail, (int)1);
    }

    private final List<A> cons(A a, List<? extends A> l) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(a), (Iterable)l);
    }

    public final boolean isEmpty() {
        return this.lIn.isEmpty() && this.lOut.isEmpty();
    }

    public final boolean isNotEmpty() {
        return ListKFoldableKt.nonEmpty(this.lIn) || ListKFoldableKt.nonEmpty(this.lOut);
    }

    public final A head() {
        Object object;
        if (ListKFoldableKt.nonEmpty(this.lOut)) {
            object = this.head((Iterable)this.lOut);
        } else if (ListKFoldableKt.nonEmpty(this.lIn)) {
            object = CollectionsKt.last(this.lIn);
        } else {
            throw (Throwable)new NoSuchElementException("head on empty queue");
        }
        return object;
    }

    @NotNull
    public final IQueue<A> tail() {
        IQueue<A> iQueue;
        if (ListKFoldableKt.nonEmpty(this.lOut)) {
            iQueue = new IQueue<A>(this.lIn, this.tail((Iterable)this.lOut));
        } else if (ListKFoldableKt.nonEmpty(this.lIn)) {
            iQueue = new IQueue<A>(CollectionsKt.emptyList(), this.tail(CollectionsKt.reversed((Iterable)this.lIn)));
        } else {
            throw (Throwable)new NoSuchElementException("tail on empty queue");
        }
        return iQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean forAll(@NotNull Function1<? super A, Boolean> p) {
        Object element$iv2;
        boolean bl;
        Intrinsics.checkNotNullParameter(p, (String)"p");
        Iterable $this$all$iv = this.lIn;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv2 : $this$all$iv) {
                if (((Boolean)p.invoke(element$iv2)).booleanValue()) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        $this$all$iv = this.lOut;
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (((Boolean)p.invoke(element$iv2 = iterator.next())).booleanValue());
        return false;
    }

    public final boolean exists(@NotNull Function1<? super A, Boolean> p) {
        Intrinsics.checkNotNullParameter(p, (String)"p");
        return ListKFoldableKt.exists(this.lIn, p) || ListKFoldableKt.exists(this.lOut, p);
    }

    public final int length() {
        return this.lIn.size() + this.lOut.size();
    }

    @NotNull
    public final IQueue<A> enqueue(A elem) {
        return new IQueue<A>(this.cons(elem, this.lIn), this.lOut);
    }

    @NotNull
    public final IQueue<A> enqueue(@NotNull Iterable<? extends A> elems) {
        Intrinsics.checkNotNullParameter(elems, (String)"elems");
        return new IQueue<A>(CollectionsKt.plus((Collection)CollectionsKt.reversed(elems), (Iterable)this.lIn), this.lOut);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Tuple2<A, IQueue<A>> dequeue() {
        Tuple2 tuple2;
        boolean bl;
        Collection collection;
        if (this.lOut.isEmpty()) {
            collection = this.lIn;
            bl = false;
            if (!collection.isEmpty()) {
                List rev = CollectionsKt.reversed((Iterable)this.lIn);
                tuple2 = TupleNKt.toT(this.head(rev), new IQueue<A>(CollectionsKt.emptyList(), this.tail(rev)));
                return tuple2;
            }
        }
        collection = this.lOut;
        bl = false;
        if (!(!collection.isEmpty())) throw (Throwable)new NoSuchElementException("dequeue on empty queue");
        tuple2 = TupleNKt.toT(this.head((Iterable)this.lOut), new IQueue<A>(this.lIn, this.tail((Iterable)this.lOut)));
        return tuple2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final IQueue<A> drop(int n) {
        IQueue<A> iQueue;
        boolean bl;
        Collection collection;
        if (this.lOut.isEmpty()) {
            collection = this.lIn;
            bl = false;
            if (!collection.isEmpty()) {
                iQueue = new IQueue<A>(CollectionsKt.emptyList(), CollectionsKt.drop((Iterable)CollectionsKt.reversed((Iterable)this.lIn), (int)n));
                return iQueue;
            }
        }
        collection = this.lOut;
        bl = false;
        if (!(!collection.isEmpty())) throw (Throwable)new NoSuchElementException("dequeue on empty queue");
        iQueue = new IQueue<A>(this.lIn, CollectionsKt.drop((Iterable)this.lOut, (int)n));
        return iQueue;
    }

    @NotNull
    public final Option<Tuple2<A, IQueue<A>>> dequeueOption() {
        return this.isEmpty() ? (Option)None.INSTANCE : (Option)new Some(this.dequeue());
    }

    public final A front() {
        return this.head();
    }

    @NotNull
    public final IQueue<A> filter(@NotNull Function1<? super A, Boolean> p) {
        List list;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(p, (String)"p");
        Iterable $this$filter$iv = this.lIn;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)p.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filter$iv = this.lOut;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)p.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = list = (List)destination$iv$iv;
        List list4 = list2;
        return new IQueue<A>(list4, list3);
    }

    @NotNull
    public final IQueue<A> filterNot(@NotNull Function1<? super A, Boolean> p) {
        List list;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(p, (String)"p");
        Iterable $this$filterNot$iv = this.lIn;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            if (((Boolean)p.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filterNot$iv = this.lOut;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            if (((Boolean)p.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = list = (List)destination$iv$iv;
        List list4 = list2;
        return new IQueue<A>(list4, list3);
    }

    @NotNull
    public String toString() {
        return "Queue(" + CollectionsKt.joinToString$default((Iterable)this.lIn, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ", " + CollectionsKt.joinToString$default((Iterable)this.lOut, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    @Override
    @NotNull
    public Iterator<A> iterator() {
        return this.toList().iterator();
    }

    @NotNull
    public final List<A> toList() {
        return CollectionsKt.plus((Collection)this.lOut, (Iterable)CollectionsKt.reversed((Iterable)this.lIn));
    }

    @NotNull
    public final List<A> getLIn() {
        return this.lIn;
    }

    @NotNull
    public final List<A> getLOut() {
        return this.lOut;
    }

    public IQueue(@NotNull List<? extends A> lIn, @NotNull List<? extends A> lOut) {
        Intrinsics.checkNotNullParameter(lIn, (String)"lIn");
        Intrinsics.checkNotNullParameter(lOut, (String)"lOut");
        this.lIn = lIn;
        this.lOut = lOut;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u0005J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0007\u001a\u0002H\u0005H\u0086\u0002\u00a2\u0006\u0002\u0010\bJ.\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\t\"\u0002H\u0005H\u0086\u0002\u00a2\u0006\u0002\u0010\nJ#\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000bH\u0086\u0002\u00a8\u0006\f"}, d2={"Larrow/fx/internal/IQueue$Companion;", "", "()V", "empty", "Larrow/fx/internal/IQueue;", "A", "invoke", "a", "(Ljava/lang/Object;)Larrow/fx/internal/IQueue;", "", "([Ljava/lang/Object;)Larrow/fx/internal/IQueue;", "", "arrow-fx"})
    public static final class Companion {
        @NotNull
        public final <A> IQueue<A> empty() {
            IQueue iQueue = IQueueKt.access$getEmptyQueue$p();
            if (iQueue == null) {
                throw new NullPointerException("null cannot be cast to non-null type arrow.fx.internal.IQueue<A>");
            }
            return iQueue;
        }

        @NotNull
        public final <A> IQueue<A> invoke(A ... a) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            return new IQueue(CollectionsKt.emptyList(), ArraysKt.toList((Object[])a));
        }

        @NotNull
        public final <A> IQueue<A> invoke(A a) {
            return new IQueue(CollectionsKt.emptyList(), CollectionsKt.listOf(a));
        }

        @NotNull
        public final <A> IQueue<A> invoke(@NotNull List<? extends A> a) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            return new IQueue<A>(CollectionsKt.emptyList(), a);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

