/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Counted;
import io.astefanutti.metrics.cdi.MetricResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Counted
@Interceptor
@Priority(value=1010)
class CountedInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    private CountedInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry, MetricResolver resolver) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = resolver;
    }

    @AroundConstruct
    private Object countedConstructor(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object countedMethod(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    @AroundTimeout
    private Object countedTimeout(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object countedCallable(InvocationContext context, E element) throws Exception {
        MetricResolver.Of<Counted> counted = this.resolver.counted(this.bean.getBeanClass(), element);
        Counter counter = (Counter)this.registry.getMetrics().get(counted.metricName());
        if (counter == null) {
            throw new IllegalStateException("No counter with name [" + counted.metricName() + "] found in registry [" + this.registry + "]");
        }
        counter.inc();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (!counted.metricAnnotation().monotonic()) {
                counter.dec();
            }
        }
    }
}

