/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import io.astefanutti.metrics.cdi.MetricsExtension;
import io.astefanutti.metrics.cdi.SeMetricName;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.enterprise.inject.Vetoed;

@Vetoed
final class ElMetricName
extends SeMetricName {
    private static final Pattern PATTERN = Pattern.compile("[#|$]\\{(.*)\\}");
    private final ELResolver elResolver;
    private final ExpressionFactory expressionFactory;

    ElMetricName(ELResolver resolver, ExpressionFactory expressionFactory, MetricsExtension extension) {
        super(extension);
        CompositeELResolver composite = new CompositeELResolver();
        composite.add(resolver);
        composite.add((ELResolver)new MapELResolver());
        composite.add((ELResolver)new ListELResolver());
        composite.add((ELResolver)new ArrayELResolver());
        composite.add((ELResolver)new ResourceBundleELResolver());
        composite.add((ELResolver)new BeanELResolver(true));
        this.elResolver = composite;
        this.expressionFactory = expressionFactory;
    }

    @Override
    public String of(String attribute) {
        Matcher matcher = PATTERN.matcher(attribute);
        if (!matcher.find()) {
            return super.of(attribute);
        }
        return this.evaluateCompositeExpression(matcher);
    }

    private String evaluateCompositeExpression(Matcher matcher) {
        StringBuffer buffer = new StringBuffer();
        do {
            String result;
            matcher.appendReplacement(buffer, (result = this.evaluateExpression(matcher.group())) != null ? result : "");
        } while (matcher.find());
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String evaluateExpression(String name) {
        ELContext context = this.createELContext(this.elResolver, new FunctionMapper(){

            public Method resolveFunction(String prefix, String localName) {
                return null;
            }
        }, new VariableMapper(){

            public ValueExpression resolveVariable(String variable) {
                return null;
            }

            public ValueExpression setVariable(String variable, ValueExpression expression) {
                return null;
            }
        });
        return (String)this.expressionFactory.createValueExpression(context, name, String.class).getValue(context);
    }

    private ELContext createELContext(final ELResolver resolver, final FunctionMapper functionMapper, final VariableMapper variableMapper) {
        return new ELContext(){

            public ELResolver getELResolver() {
                return resolver;
            }

            public FunctionMapper getFunctionMapper() {
                return functionMapper;
            }

            public VariableMapper getVariableMapper() {
                return variableMapper;
            }
        };
    }
}

