/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.astefanutti.metrics.cdi.MetricName;
import io.astefanutti.metrics.cdi.MetricsExtension;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.util.Optional;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;

@Alternative
@Dependent
@Priority(value=1000)
final class MetricProducer {
    MetricProducer() {
    }

    @Produces
    private static Counter counter(InjectionPoint ip, MetricRegistry registry, MetricName metricName) {
        return registry.counter(metricName.of(ip));
    }

    @Produces
    private static <T> Gauge<T> gauge(InjectionPoint ip, MetricRegistry registry, MetricName metricName) {
        return () -> {
            Gauge gauge = (Gauge)registry.getGauges().get(metricName.of(ip));
            return gauge.getValue();
        };
    }

    @Produces
    private static Histogram histogram(InjectionPoint ip, MetricRegistry registry, MetricName metricName, MetricsExtension extension) {
        String name = metricName.of(ip);
        return extension.getParameter(MetricsParameter.ReservoirFunction).flatMap(function -> (Optional)function.apply(name, Histogram.class)).map(reservoir -> registry.histogram(name, () -> new Histogram(reservoir))).orElseGet(() -> registry.histogram(name));
    }

    @Produces
    private static Meter meter(InjectionPoint ip, MetricRegistry registry, MetricName metricName) {
        return registry.meter(metricName.of(ip));
    }

    @Produces
    private static Timer timer(InjectionPoint ip, MetricRegistry registry, MetricName metricName, MetricsExtension extension) {
        String name = metricName.of(ip);
        return extension.getParameter(MetricsParameter.ReservoirFunction).flatMap(function -> (Optional)function.apply(name, Timer.class)).map(reservoir -> registry.timer(name, () -> new Timer(reservoir))).orElseGet(() -> registry.timer(name));
    }
}

