/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.Metric;
import com.codahale.metrics.Reservoir;
import io.astefanutti.metrics.cdi.MetricsConfiguration;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

final class MetricsConfigurationEvent
implements MetricsConfiguration {
    private final EnumMap<MetricsParameter, Object> configuration = new EnumMap(MetricsParameter.class);
    private volatile boolean unmodifiable;

    MetricsConfigurationEvent() {
    }

    @Override
    public MetricsConfiguration useAbsoluteName(boolean useAbsoluteName) {
        this.throwsIfUnmodifiable();
        this.configuration.put(MetricsParameter.UseAbsoluteName, (Object)useAbsoluteName);
        return this;
    }

    @Override
    public MetricsConfiguration reservoirFunction(BiFunction<String, Class<? extends Metric>, Optional<Reservoir>> function) {
        this.throwsIfUnmodifiable();
        this.configuration.put(MetricsParameter.ReservoirFunction, function);
        return this;
    }

    Map<MetricsParameter, Object> getParameters() {
        return Collections.unmodifiableMap(this.configuration);
    }

    void unmodifiable() {
        this.unmodifiable = true;
    }

    private void throwsIfUnmodifiable() {
        if (this.unmodifiable) {
            throw new IllegalStateException("Metrics CDI configuration event must not be used outside its observer method!");
        }
    }
}

