/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.CachedGauge;
import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import io.astefanutti.metrics.cdi.MetricResolver;
import io.astefanutti.metrics.cdi.MetricsBinding;
import io.astefanutti.metrics.cdi.MetricsExtension;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@MetricsBinding
@Priority(value=1000)
class MetricsInterceptor {
    private final MetricRegistry registry;
    private final MetricResolver resolver;
    private final MetricsExtension extension;

    @Inject
    private MetricsInterceptor(MetricRegistry registry, MetricResolver resolver, MetricsExtension extension) {
        this.registry = registry;
        this.resolver = resolver;
        this.extension = extension;
    }

    @AroundConstruct
    private Object metrics(InvocationContext context) throws Exception {
        Class bean = context.getConstructor().getDeclaringClass();
        this.registerMetrics(bean, context.getConstructor());
        Class type = bean;
        do {
            for (Method method : type.getDeclaredMethods()) {
                if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
                this.registerMetrics(bean, method);
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        Object target = context.proceed();
        type = bean;
        do {
            for (Method method : type.getDeclaredMethods()) {
                MetricResolver.Of<com.codahale.metrics.annotation.Gauge> gauge;
                MetricResolver.Of<CachedGauge> cachedGauge = this.resolver.cachedGauge(bean, method);
                if (cachedGauge.isPresent()) {
                    this.registry.register(cachedGauge.metricName(), (Metric)new CachingGauge(new ForwardingGauge(method, context.getTarget()), cachedGauge.metricAnnotation().timeout(), cachedGauge.metricAnnotation().timeoutUnit()));
                }
                if (!(gauge = this.resolver.gauge(bean, method)).isPresent()) continue;
                this.registry.register(gauge.metricName(), (Metric)new ForwardingGauge(method, context.getTarget()));
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        return target;
    }

    private <E extends Member & AnnotatedElement> void registerMetrics(Class<?> bean, E element) {
        MetricResolver.Of<Timed> timed;
        MetricResolver.Of<Metered> metered;
        MetricResolver.Of<ExceptionMetered> exceptionMetered;
        MetricResolver.Of<Counted> counted = this.resolver.counted(bean, element);
        if (counted.isPresent()) {
            this.registry.counter(counted.metricName());
        }
        if ((exceptionMetered = this.resolver.exceptionMetered(bean, element)).isPresent()) {
            this.registry.meter(exceptionMetered.metricName());
        }
        if ((metered = this.resolver.metered(bean, element)).isPresent()) {
            this.registry.meter(metered.metricName());
        }
        if ((timed = this.resolver.timed(bean, element)).isPresent()) {
            this.extension.getParameter(MetricsParameter.ReservoirFunction).flatMap(function -> (Optional)function.apply(timed.metricName(), Timer.class)).map(reservoir -> this.registry.timer(timed.metricName(), () -> new Timer(reservoir))).orElseGet(() -> this.registry.timer(timed.metricName()));
        }
    }

    private static Object invokeMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
    }

    private static final class ForwardingGauge
    implements Gauge<Object> {
        private final Method method;
        private final Object object;

        private ForwardingGauge(Method method, Object object) {
            this.method = method;
            this.object = object;
            method.setAccessible(true);
        }

        public Object getValue() {
            return MetricsInterceptor.invokeMethod(this.method, this.object);
        }
    }

    private static final class CachingGauge
    extends com.codahale.metrics.CachedGauge<Object> {
        private final Gauge<?> gauge;

        private CachingGauge(Gauge<?> gauge, long timeout, TimeUnit timeoutUnit) {
            super(timeout, timeoutUnit);
            this.gauge = gauge;
        }

        protected Object loadValue() {
            return this.gauge.getValue();
        }
    }
}

