/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Metric;
import io.astefanutti.metrics.cdi.MetricName;
import io.astefanutti.metrics.cdi.MetricsExtension;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;

@Vetoed
class SeMetricName
implements MetricName {
    private final MetricsExtension extension;

    SeMetricName(MetricsExtension extension) {
        this.extension = extension;
    }

    @Override
    public String of(InjectionPoint ip) {
        Annotated annotated = ip.getAnnotated();
        if (annotated instanceof AnnotatedMember) {
            return this.of((AnnotatedMember)annotated);
        }
        if (annotated instanceof AnnotatedParameter) {
            return this.of((AnnotatedParameter)annotated);
        }
        throw new IllegalArgumentException("Unable to retrieve metric name for injection point [" + ip + "], only members and parameters are supported");
    }

    @Override
    public String of(AnnotatedMember<?> member) {
        if (member.isAnnotationPresent(Metric.class)) {
            Metric metric = (Metric)member.getAnnotation(Metric.class);
            String name = metric.name().isEmpty() ? member.getJavaMember().getName() : this.of(metric.name());
            return metric.absolute() | this.extension.getParameter(MetricsParameter.UseAbsoluteName).orElse(false) ? name : MetricRegistry.name(member.getJavaMember().getDeclaringClass(), (String[])new String[]{name});
        }
        return this.extension.getParameter(MetricsParameter.UseAbsoluteName).orElse(false) != false ? member.getJavaMember().getName() : MetricRegistry.name(member.getJavaMember().getDeclaringClass(), (String[])new String[]{member.getJavaMember().getName()});
    }

    @Override
    public String of(String attribute) {
        return attribute;
    }

    private String of(AnnotatedParameter<?> parameter) {
        if (parameter.isAnnotationPresent(Metric.class)) {
            Metric metric = (Metric)parameter.getAnnotation(Metric.class);
            String name = metric.name().isEmpty() ? this.getParameterName(parameter) : this.of(metric.name());
            return metric.absolute() | this.extension.getParameter(MetricsParameter.UseAbsoluteName).orElse(false) ? name : MetricRegistry.name(parameter.getDeclaringCallable().getJavaMember().getDeclaringClass(), (String[])new String[]{name});
        }
        return this.extension.getParameter(MetricsParameter.UseAbsoluteName).orElse(false) != false ? this.getParameterName(parameter) : MetricRegistry.name(parameter.getDeclaringCallable().getJavaMember().getDeclaringClass(), (String[])new String[]{this.getParameterName(parameter)});
    }

    private String getParameterName(AnnotatedParameter<?> parameter) {
        Parameter[] parameters = ((Method)parameter.getDeclaringCallable().getJavaMember()).getParameters();
        Parameter param = parameters[parameter.getPosition()];
        if (param.isNamePresent()) {
            return param.getName();
        }
        throw new UnsupportedOperationException("Unable to retrieve name for parameter [" + parameter + "], activate the -parameters compiler argument or annotate the injected parameter with the @Metric annotation");
    }
}

