/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.ServerVersion;
import io.asyncer.r2dbc.mysql.authentication.MySqlAuthProvider;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.client.FluxExchangeable;
import io.asyncer.r2dbc.mysql.constant.SslMode;
import io.asyncer.r2dbc.mysql.message.client.AuthResponse;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.asyncer.r2dbc.mysql.message.client.HandshakeResponse;
import io.asyncer.r2dbc.mysql.message.client.LoginClientMessage;
import io.asyncer.r2dbc.mysql.message.client.SslRequest;
import io.asyncer.r2dbc.mysql.message.server.AuthMoreDataMessage;
import io.asyncer.r2dbc.mysql.message.server.ChangeAuthMessage;
import io.asyncer.r2dbc.mysql.message.server.ErrorMessage;
import io.asyncer.r2dbc.mysql.message.server.HandshakeHeader;
import io.asyncer.r2dbc.mysql.message.server.HandshakeRequest;
import io.asyncer.r2dbc.mysql.message.server.OkMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.asyncer.r2dbc.mysql.message.server.SyntheticSslResponseMessage;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Sinks;
import reactor.core.publisher.SynchronousSink;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;

final class LoginExchangeable
extends FluxExchangeable<Void> {
    private static final Logger logger = Loggers.getLogger(LoginExchangeable.class);
    private static final Map<String, String> ATTRIBUTES = Collections.emptyMap();
    private static final String CLI_SPECIFIC = "HY000";
    private static final int HANDSHAKE_VERSION = 10;
    private final Sinks.Many<LoginClientMessage> requests = Sinks.many().unicast().onBackpressureBuffer((Queue)Queues.one().get());
    private final Client client;
    private final SslMode sslMode;
    private final String database;
    private final String user;
    @Nullable
    private final CharSequence password;
    private final ConnectionContext context;
    private boolean handshake = true;
    private MySqlAuthProvider authProvider;
    private byte[] salt;
    private boolean sslCompleted;
    private int lastEnvelopeId;

    LoginExchangeable(Client client, SslMode sslMode, String database, String user, @Nullable CharSequence password, ConnectionContext context) {
        this.client = client;
        this.sslMode = sslMode;
        this.database = database;
        this.user = user;
        this.password = password;
        this.context = context;
        this.sslCompleted = sslMode == SslMode.TUNNEL;
    }

    public void subscribe(CoreSubscriber<? super ClientMessage> actual) {
        this.requests.asFlux().subscribe(actual);
    }

    @Override
    public void accept(ServerMessage message, SynchronousSink<Void> sink) {
        if (message instanceof ErrorMessage) {
            sink.error((Throwable)((ErrorMessage)message).toException());
            return;
        }
        if (this.handshake) {
            this.handshake = false;
            if (message instanceof HandshakeRequest) {
                HandshakeRequest request = (HandshakeRequest)message;
                Capability capability = this.initHandshake(request);
                this.lastEnvelopeId = request.getEnvelopeId() + 1;
                if (capability.isSslEnabled()) {
                    this.emitNext(SslRequest.from(this.lastEnvelopeId, capability, this.context.getClientCollation().getId()), sink);
                } else {
                    this.emitNext(this.createHandshakeResponse(this.lastEnvelopeId, capability), sink);
                }
            } else {
                sink.error((Throwable)new R2dbcPermissionDeniedException("Unexpected message type '" + message.getClass().getSimpleName() + "' in init phase"));
            }
            return;
        }
        if (message instanceof OkMessage) {
            this.client.loginSuccess();
            sink.complete();
        } else if (message instanceof SyntheticSslResponseMessage) {
            this.sslCompleted = true;
            this.emitNext(this.createHandshakeResponse(++this.lastEnvelopeId, this.context.getCapability()), sink);
        } else if (message instanceof AuthMoreDataMessage) {
            AuthMoreDataMessage msg = (AuthMoreDataMessage)message;
            this.lastEnvelopeId = msg.getEnvelopeId() + 1;
            if (msg.isFailed()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Connection (id {}) fast authentication failed, use full authentication", new Object[]{this.context.getConnectionId()});
                }
                this.emitNext(this.createAuthResponse(this.lastEnvelopeId, "full authentication"), sink);
            }
        } else if (message instanceof ChangeAuthMessage) {
            ChangeAuthMessage msg = (ChangeAuthMessage)message;
            this.lastEnvelopeId = msg.getEnvelopeId() + 1;
            this.authProvider = MySqlAuthProvider.build(msg.getAuthType());
            this.salt = msg.getSalt();
            this.emitNext(this.createAuthResponse(this.lastEnvelopeId, "change authentication"), sink);
        } else {
            sink.error((Throwable)new R2dbcPermissionDeniedException("Unexpected message type '" + message.getClass().getSimpleName() + "' in login phase"));
        }
    }

    public void dispose() {
        this.requests.tryEmitComplete();
    }

    private void emitNext(LoginClientMessage message, SynchronousSink<Void> sink) {
        Sinks.EmitResult result = this.requests.tryEmitNext((Object)message);
        if (result != Sinks.EmitResult.OK) {
            sink.error((Throwable)new IllegalStateException("Fail to emit a login request due to " + result));
        }
    }

    private AuthResponse createAuthResponse(int envelopeId, String phase) {
        MySqlAuthProvider authProvider = this.getAndNextProvider();
        if (authProvider.isSslNecessary() && !this.sslCompleted) {
            throw new R2dbcPermissionDeniedException(LoginExchangeable.authFails(authProvider.getType(), phase), CLI_SPECIFIC);
        }
        return new AuthResponse(envelopeId, authProvider.authentication(this.password, this.salt, this.context.getClientCollation()));
    }

    private Capability clientCapability(Capability serverCapability) {
        Capability.Builder builder = serverCapability.mutate();
        builder.disableDatabasePinned();
        builder.disableCompression();
        builder.disableLoadDataInfile();
        builder.disableIgnoreAmbiguitySpace();
        builder.disableInteractiveTimeout();
        if (this.sslMode == SslMode.TUNNEL) {
            builder.disableSsl();
        } else if (!serverCapability.isSslEnabled()) {
            if (this.sslMode.requireSsl()) {
                throw new R2dbcPermissionDeniedException("Server version '" + this.context.getServerVersion() + "' does not support SSL but mode '" + (Object)((Object)this.sslMode) + "' requires SSL", CLI_SPECIFIC);
            }
            if (this.sslMode.startSsl()) {
                this.client.sslUnsupported();
            }
        } else if (!this.sslMode.startSsl()) {
            builder.disableSsl();
        }
        if (this.database.isEmpty()) {
            builder.disableConnectWithDatabase();
        }
        if (ATTRIBUTES.isEmpty()) {
            builder.disableConnectAttributes();
        }
        return builder.build();
    }

    private Capability initHandshake(HandshakeRequest message) {
        HandshakeHeader header = message.getHeader();
        short handshakeVersion = header.getProtocolVersion();
        ServerVersion serverVersion = header.getServerVersion();
        if (handshakeVersion < 10) {
            logger.warn("MySQL use handshake V{}, server version is {}, maybe most features are unavailable", new Object[]{(int)handshakeVersion, serverVersion});
        }
        Capability capability = this.clientCapability(message.getServerCapability());
        this.context.init(header.getConnectionId(), serverVersion, capability);
        this.authProvider = MySqlAuthProvider.build(message.getAuthType());
        this.salt = message.getSalt();
        return capability;
    }

    private MySqlAuthProvider getAndNextProvider() {
        MySqlAuthProvider authProvider = this.authProvider;
        this.authProvider = authProvider.next();
        return authProvider;
    }

    private HandshakeResponse createHandshakeResponse(int envelopeId, Capability capability) {
        MySqlAuthProvider authProvider = this.getAndNextProvider();
        if (authProvider.isSslNecessary() && !this.sslCompleted) {
            throw new R2dbcPermissionDeniedException(LoginExchangeable.authFails(authProvider.getType(), "handshake"), CLI_SPECIFIC);
        }
        byte[] authorization = authProvider.authentication(this.password, this.salt, this.context.getClientCollation());
        String authType = authProvider.getType();
        if ("".equals(authType)) {
            authType = "caching_sha2_password";
        }
        return HandshakeResponse.from(envelopeId, capability, this.context.getClientCollation().getId(), this.user, authorization, authType, this.database, ATTRIBUTES);
    }

    private static String authFails(String authType, String phase) {
        return "Authentication type '" + authType + "' must require SSL in " + phase + " phase";
    }
}

