/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractClassedCodec;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.LocalTimeCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import reactor.core.publisher.Mono;

final class OffsetTimeCodec
extends AbstractClassedCodec<OffsetTime> {
    OffsetTimeCodec(ByteBufAllocator allocator) {
        super(allocator, OffsetTime.class);
    }

    @Override
    public OffsetTime decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        LocalTime origin = LocalTimeCodec.decodeOrigin(binary, value);
        ZoneId zone = context.getServerZoneId();
        return OffsetTime.of(origin, zone instanceof ZoneOffset ? (ZoneOffset)zone : zone.getRules().getStandardOffset(Instant.EPOCH));
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new OffsetTimeMySqlParameter(this.allocator, (OffsetTime)value, context);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof OffsetTime;
    }

    @Override
    public boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType() == MySqlType.TIME;
    }

    private static final class OffsetTimeMySqlParameter
    extends AbstractMySqlParameter {
        private final ByteBufAllocator allocator;
        private final OffsetTime value;
        private final CodecContext context;

        private OffsetTimeMySqlParameter(ByteBufAllocator allocator, OffsetTime value, CodecContext context) {
            this.allocator = allocator;
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> LocalTimeCodec.encodeBinary(this.allocator, this.serverValue()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalTimeCodec.encodeTime(writer, this.serverValue()));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TIME;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OffsetTimeMySqlParameter)) {
                return false;
            }
            OffsetTimeMySqlParameter that = (OffsetTimeMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        private LocalTime serverValue() {
            ZoneId zone = this.context.getServerZoneId();
            ZoneOffset offset = zone instanceof ZoneOffset ? (ZoneOffset)zone : zone.getRules().getStandardOffset(Instant.EPOCH);
            return this.value.toLocalTime().plusSeconds(offset.getTotalSeconds() - this.value.getOffset().getTotalSeconds());
        }
    }
}

