/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.codec.AbstractClassedCodec;
import io.asyncer.r2dbc.mysql.codec.ByteCodec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.codec.IntegerCodec;
import io.asyncer.r2dbc.mysql.codec.ShortCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Year;

final class YearCodec
extends AbstractClassedCodec<Year> {
    YearCodec(ByteBufAllocator allocator) {
        super(allocator, Year.class);
    }

    @Override
    public Year decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return binary ? Year.of(value.readShortLE()) : Year.of(CodecUtils.parseInt(value));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Year;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        int year = ((Year)value).getValue();
        if ((byte)year == year) {
            return new ByteCodec.ByteMySqlParameter(this.allocator, (byte)year);
        }
        if ((short)year == year) {
            return new ShortCodec.ShortMySqlParameter(this.allocator, (short)year);
        }
        return new IntegerCodec.IntMySqlParameter(this.allocator, year);
    }

    @Override
    public boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType() == MySqlType.YEAR;
    }
}

