/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;

public final class PrepareQueryMessage
implements ClientMessage {
    private static final byte PREPARE_FLAG = 22;
    private final String sql;

    public PrepareQueryMessage(String sql) {
        this.sql = sql;
    }

    public Flux<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        return Flux.defer(() -> {
            Charset charset = context.getClientCollation().getCharset();
            ByteBuf buf = allocator.buffer();
            try {
                buf.writeByte(22).writeCharSequence((CharSequence)this.sql, charset);
                return Flux.just((Object)buf);
            }
            catch (Throwable e) {
                buf.release();
                return Flux.error((Throwable)e);
            }
        });
    }

    public String toString() {
        return "PrepareQueryMessage{sql=REDACTED}";
    }
}

