/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.ColumnDefinition;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.asyncer.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class DefinitionMetadataMessage
implements ServerMessage {
    @Nullable
    private final String database;
    private final String table;
    @Nullable
    private final String originTable;
    private final String column;
    @Nullable
    private final String originColumn;
    private final int collationId;
    private final long size;
    private final short typeId;
    private final ColumnDefinition definition;
    private final short decimals;

    private DefinitionMetadataMessage(@Nullable String database, String table, @Nullable String originTable, String column, @Nullable String originColumn, int collationId, long size, short typeId, ColumnDefinition definition, short decimals) {
        AssertUtils.require(size >= 0L, "size must not be a negative integer");
        AssertUtils.require(collationId > 0, "collationId must be a positive integer");
        this.database = database;
        this.table = AssertUtils.requireNonNull(table, "table must not be null");
        this.originTable = originTable;
        this.column = AssertUtils.requireNonNull(column, "column must not be null");
        this.originColumn = originColumn;
        this.collationId = collationId;
        this.size = size;
        this.typeId = typeId;
        this.definition = AssertUtils.requireNonNull(definition, "definition must not be null");
        this.decimals = decimals;
    }

    public String getColumn() {
        return this.column;
    }

    public int getCollationId() {
        return this.collationId;
    }

    public long getSize() {
        return this.size;
    }

    public short getTypeId() {
        return this.typeId;
    }

    public ColumnDefinition getDefinition() {
        return this.definition;
    }

    public short getDecimals() {
        return this.decimals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefinitionMetadataMessage)) {
            return false;
        }
        DefinitionMetadataMessage that = (DefinitionMetadataMessage)o;
        return this.collationId == that.collationId && this.size == that.size && this.typeId == that.typeId && this.definition.equals(that.definition) && this.decimals == that.decimals && Objects.equals(this.database, that.database) && this.table.equals(that.table) && Objects.equals(this.originTable, that.originTable) && this.column.equals(that.column) && Objects.equals(this.originColumn, that.originColumn);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.table, this.originTable, this.column, this.originColumn, this.collationId, this.size, this.typeId, this.definition, this.decimals);
    }

    public String toString() {
        return "DefinitionMetadataMessage{database='" + this.database + "', table='" + this.table + "' (origin:'" + this.originTable + "'), column='" + this.column + "' (origin:'" + this.originColumn + "'), collationId=" + this.collationId + ", size=" + this.size + ", type=" + this.typeId + ", definition=" + this.definition + ", decimals=" + this.decimals + '}';
    }

    static DefinitionMetadataMessage decode(ByteBuf buf, ConnectionContext context) {
        if (context.getCapability().isProtocol41()) {
            return DefinitionMetadataMessage.decode41(buf, context);
        }
        return DefinitionMetadataMessage.decode320(buf, context);
    }

    private static DefinitionMetadataMessage decode320(ByteBuf buf, ConnectionContext context) {
        CharCollation collation = context.getClientCollation();
        Charset charset = collation.getCharset();
        String table = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String column = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        buf.skipBytes(1);
        int size = buf.readUnsignedMediumLE();
        buf.skipBytes(1);
        short typeId = buf.readUnsignedByte();
        buf.skipBytes(1);
        ColumnDefinition definition = ColumnDefinition.of(buf.readShortLE());
        short decimals = buf.readUnsignedByte();
        return new DefinitionMetadataMessage(null, table, null, column, null, collation.getId(), size, typeId, definition, decimals);
    }

    private static DefinitionMetadataMessage decode41(ByteBuf buf, ConnectionContext context) {
        buf.skipBytes(4);
        CharCollation collation = context.getClientCollation();
        Charset charset = collation.getCharset();
        String database = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String table = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String originTable = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String column = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String originColumn = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        VarIntUtils.readVarInt(buf);
        int collationId = buf.readUnsignedShortLE();
        long size = buf.readUnsignedIntLE();
        short typeId = buf.readUnsignedByte();
        ColumnDefinition definition = ColumnDefinition.of(buf.readShortLE());
        return new DefinitionMetadataMessage(database, table, originTable, column, originColumn, collationId, size, typeId, definition, buf.readUnsignedByte());
    }

    private static String readVarIntSizedString(ByteBuf buf, Charset charset) {
        int bytes = (int)VarIntUtils.readVarInt(buf);
        if (bytes == 0) {
            return "";
        }
        String result = buf.toString(buf.readerIndex(), bytes, charset);
        buf.skipBytes(bytes);
        return result;
    }
}

