/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import io.asyncer.r2dbc.mysql.message.server.EofMessage;
import io.asyncer.r2dbc.mysql.message.server.MetadataDecodeContext;
import io.asyncer.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.util.annotation.Nullable;

final class ResultDecodeContext
extends MetadataDecodeContext {
    private final DefinitionMetadataMessage[] metadataMessages;
    private final AtomicInteger columns = new AtomicInteger();
    private boolean inMetadata = true;

    ResultDecodeContext(boolean eofDeprecated, int totalColumns) {
        super(eofDeprecated);
        AssertUtils.require(totalColumns > 0, "result must has least 1 column");
        this.metadataMessages = new DefinitionMetadataMessage[totalColumns];
    }

    public String toString() {
        return "DecodeContext-Result";
    }

    @Override
    boolean isInMetadata() {
        return this.inMetadata;
    }

    @Override
    protected SyntheticMetadataMessage checkComplete(int index, @Nullable EofMessage eof) {
        if (index == this.metadataMessages.length) {
            this.inMetadata = false;
            return new SyntheticMetadataMessage(false, this.metadataMessages, eof);
        }
        return null;
    }

    @Override
    protected int putMetadata(DefinitionMetadataMessage metadata) {
        int size;
        int index = this.columns.getAndIncrement();
        if (index >= (size = this.metadataMessages.length)) {
            throw new IllegalStateException("Columns metadata has filled up, now index: " + index + ", array length: " + size);
        }
        this.metadataMessages[index] = metadata;
        return index + 1;
    }

    @Override
    protected int currentIndex() {
        return this.columns.get();
    }

    @Override
    protected Object loggingPoints() {
        return this.metadataMessages.length;
    }
}

