/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.message.server.AuthMoreDataMessage;
import io.asyncer.r2dbc.mysql.message.server.ByteBufCombiner;
import io.asyncer.r2dbc.mysql.message.server.ChangeAuthMessage;
import io.asyncer.r2dbc.mysql.message.server.ColumnCountMessage;
import io.asyncer.r2dbc.mysql.message.server.CommandDecodeContext;
import io.asyncer.r2dbc.mysql.message.server.DecodeContext;
import io.asyncer.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import io.asyncer.r2dbc.mysql.message.server.EofMessage;
import io.asyncer.r2dbc.mysql.message.server.ErrorMessage;
import io.asyncer.r2dbc.mysql.message.server.FetchDecodeContext;
import io.asyncer.r2dbc.mysql.message.server.FieldReader;
import io.asyncer.r2dbc.mysql.message.server.HandshakeRequest;
import io.asyncer.r2dbc.mysql.message.server.LoginDecodeContext;
import io.asyncer.r2dbc.mysql.message.server.MetadataDecodeContext;
import io.asyncer.r2dbc.mysql.message.server.OkMessage;
import io.asyncer.r2dbc.mysql.message.server.PrepareQueryDecodeContext;
import io.asyncer.r2dbc.mysql.message.server.PreparedMetadataDecodeContext;
import io.asyncer.r2dbc.mysql.message.server.PreparedOkMessage;
import io.asyncer.r2dbc.mysql.message.server.ResultDecodeContext;
import io.asyncer.r2dbc.mysql.message.server.RowMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerStatusMessage;
import io.asyncer.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.asyncer.r2dbc.mysql.util.NettyBufferUtils;
import io.asyncer.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import java.util.ArrayList;
import java.util.List;
import reactor.util.annotation.Nullable;

public final class ServerMessageDecoder {
    private static final short OK = 0;
    private static final short AUTH_MORE_DATA = 1;
    private static final short HANDSHAKE_V9 = 9;
    private static final short HANDSHAKE_V10 = 10;
    private static final short EOF = 254;
    private static final short ERROR = 255;
    private final List<ByteBuf> parts = new ArrayList<ByteBuf>();

    @Nullable
    public ServerMessage decode(ByteBuf envelope, ConnectionContext context, DecodeContext decodeContext) {
        AssertUtils.requireNonNull(envelope, "envelope must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(decodeContext, "decodeContext must not be null");
        List<ByteBuf> buffers = this.parts;
        Byte id = ServerMessageDecoder.readNotFinish(buffers, envelope);
        if (id == null) {
            return null;
        }
        return ServerMessageDecoder.decodeMessage(buffers, id.intValue() & 0xFF, context, decodeContext);
    }

    public void dispose() {
        if (this.parts.isEmpty()) {
            return;
        }
        NettyBufferUtils.releaseAll(this.parts);
        this.parts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ServerMessage decodeMessage(List<ByteBuf> buffers, int envelopeId, ConnectionContext context, DecodeContext decodeContext) {
        if (decodeContext instanceof ResultDecodeContext) {
            return ServerMessageDecoder.decodeResult(buffers, context, (ResultDecodeContext)decodeContext);
        }
        if (decodeContext instanceof FetchDecodeContext) {
            return ServerMessageDecoder.decodeFetch(buffers, context);
        }
        ByteBuf combined = ByteBufCombiner.composite(buffers);
        try {
            if (decodeContext instanceof CommandDecodeContext) {
                ServerMessage serverMessage = ServerMessageDecoder.decodeCommandMessage(combined, context);
                return serverMessage;
            }
            if (decodeContext instanceof PreparedMetadataDecodeContext) {
                ServerMessage serverMessage = ServerMessageDecoder.decodePreparedMetadata(combined, context, (PreparedMetadataDecodeContext)decodeContext);
                return serverMessage;
            }
            if (decodeContext instanceof PrepareQueryDecodeContext) {
                ServerMessage serverMessage = ServerMessageDecoder.decodePrepareQuery(combined);
                return serverMessage;
            }
            if (decodeContext instanceof LoginDecodeContext) {
                ServerMessage serverMessage = ServerMessageDecoder.decodeLogin(envelopeId, combined, context);
                return serverMessage;
            }
        }
        finally {
            combined.release();
        }
        throw new IllegalStateException("unknown decode context type: " + decodeContext.getClass());
    }

    @Nullable
    private static ServerMessage decodePreparedMetadata(ByteBuf buf, ConnectionContext context, PreparedMetadataDecodeContext decodeContext) {
        short header = buf.getUnsignedByte(buf.readerIndex());
        if (header == 255) {
            return ErrorMessage.decode(buf);
        }
        if (decodeContext.isInMetadata()) {
            return ServerMessageDecoder.decodeInMetadata(buf, header, context, decodeContext);
        }
        throw new R2dbcNonTransientResourceException("Unknown message header 0x" + Integer.toHexString(header) + " and readable bytes is " + buf.readableBytes() + " on prepared metadata phase");
    }

    private static ServerMessage decodeFetch(List<ByteBuf> buffers, ConnectionContext context) {
        ByteBuf firstBuf = buffers.get(0);
        short header = firstBuf.getUnsignedByte(firstBuf.readerIndex());
        ErrorMessage error = ServerMessageDecoder.decodeCheckError(buffers, header);
        if (error != null) {
            return error;
        }
        return ServerMessageDecoder.decodeRow(buffers, firstBuf, header, context, "fetch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ServerMessage decodeResult(List<ByteBuf> buffers, ConnectionContext context, ResultDecodeContext decodeContext) {
        ByteBuf firstBuf = buffers.get(0);
        short header = firstBuf.getUnsignedByte(firstBuf.readerIndex());
        ErrorMessage error = ServerMessageDecoder.decodeCheckError(buffers, header);
        if (error != null) {
            return error;
        }
        if (decodeContext.isInMetadata()) {
            ByteBuf combined = ByteBufCombiner.composite(buffers);
            try {
                SyntheticMetadataMessage syntheticMetadataMessage = ServerMessageDecoder.decodeInMetadata(combined, header, context, decodeContext);
                return syntheticMetadataMessage;
            }
            finally {
                combined.release();
            }
        }
        return ServerMessageDecoder.decodeRow(buffers, firstBuf, header, context, "result");
    }

    private static ServerMessage decodePrepareQuery(ByteBuf buf) {
        short header = buf.getUnsignedByte(buf.readerIndex());
        switch (header) {
            case 255: {
                return ErrorMessage.decode(buf);
            }
            case 0: {
                if (!PreparedOkMessage.isLooksLike(buf)) break;
                return PreparedOkMessage.decode(buf);
            }
        }
        throw new R2dbcNonTransientResourceException("Unknown message header 0x" + Integer.toHexString(header) + " and readable bytes is " + buf.readableBytes() + " on prepare query phase");
    }

    private static ServerMessage decodeCommandMessage(ByteBuf buf, ConnectionContext context) {
        short header = buf.getUnsignedByte(buf.readerIndex());
        switch (header) {
            case 255: {
                return ErrorMessage.decode(buf);
            }
            case 0: {
                if (!OkMessage.isValidSize(buf.readableBytes())) break;
                return OkMessage.decode(buf, context);
            }
            case 254: {
                int byteSize = buf.readableBytes();
                if (OkMessage.isValidSize(byteSize)) {
                    return OkMessage.decode(buf, context);
                }
                if (!EofMessage.isValidSize(byteSize)) break;
                return EofMessage.decode(buf);
            }
        }
        if (VarIntUtils.checkNextVarInt(buf) == 0) {
            return ColumnCountMessage.decode(buf);
        }
        throw new R2dbcNonTransientResourceException("Unknown message header 0x" + Integer.toHexString(header) + " and readable bytes is " + buf.readableBytes() + " on command phase");
    }

    private static ServerMessage decodeLogin(int envelopeId, ByteBuf buf, ConnectionContext context) {
        short header = buf.getUnsignedByte(buf.readerIndex());
        switch (header) {
            case 0: {
                if (!OkMessage.isValidSize(buf.readableBytes())) break;
                return OkMessage.decode(buf, context);
            }
            case 1: {
                return AuthMoreDataMessage.decode(envelopeId, buf);
            }
            case 9: 
            case 10: {
                return HandshakeRequest.decode(envelopeId, buf);
            }
            case 255: {
                return ErrorMessage.decode(buf);
            }
            case 254: {
                if (EofMessage.isValidSize(buf.readableBytes())) {
                    return EofMessage.decode(buf);
                }
                return ChangeAuthMessage.decode(envelopeId, buf);
            }
        }
        throw new R2dbcPermissionDeniedException("Unknown message header 0x" + Integer.toHexString(header) + " and readable bytes is " + buf.readableBytes() + " on connection phase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Byte readNotFinish(List<ByteBuf> buffers, ByteBuf envelope) {
        try {
            int size = envelope.readUnsignedMediumLE();
            if (size < 0xFFFFFF) {
                Byte envelopeId = envelope.readByte();
                buffers.add(envelope);
                envelope = null;
                Byte by = envelopeId;
                return by;
            }
            envelope.skipBytes(1);
            buffers.add(envelope);
            envelope = null;
            Byte by = null;
            return by;
        }
        finally {
            if (envelope != null) {
                envelope.release();
            }
        }
    }

    private static boolean isRow(List<ByteBuf> buffers, ByteBuf firstBuf, short header) {
        switch (header) {
            case 251: {
                return true;
            }
            case 254: {
                if (buffers.size() > 1) {
                    return true;
                }
                int size = firstBuf.readableBytes();
                return !EofMessage.isValidSize(size) && !OkMessage.isValidSize(size);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ErrorMessage decodeCheckError(List<ByteBuf> buffers, short header) {
        if (255 == header) {
            ByteBuf combined = ByteBufCombiner.composite(buffers);
            try {
                ErrorMessage errorMessage = ErrorMessage.decode(combined);
                return errorMessage;
            }
            finally {
                combined.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerMessage decodeRow(List<ByteBuf> buffers, ByteBuf firstBuf, short header, ConnectionContext context, String phase) {
        if (ServerMessageDecoder.isRow(buffers, firstBuf, header)) {
            return new RowMessage(FieldReader.of(buffers));
        }
        if (header == 254) {
            int byteSize = firstBuf.readableBytes();
            if (OkMessage.isValidSize(byteSize)) {
                ByteBuf combined = ByteBufCombiner.composite(buffers);
                try {
                    OkMessage okMessage = OkMessage.decode(combined, context);
                    return okMessage;
                }
                finally {
                    combined.release();
                }
            }
            if (EofMessage.isValidSize(byteSize)) {
                ByteBuf combined = ByteBufCombiner.composite(buffers);
                try {
                    EofMessage eofMessage = EofMessage.decode(combined);
                    return eofMessage;
                }
                finally {
                    combined.release();
                }
            }
        }
        long totalBytes = 0L;
        try {
            for (ByteBuf buffer : buffers) {
                if (buffer == null) continue;
                totalBytes += (long)buffer.readableBytes();
                ReferenceCountUtil.safeRelease((Object)buffer);
            }
        }
        finally {
            buffers.clear();
        }
        throw new R2dbcNonTransientResourceException("Unknown message header 0x" + Integer.toHexString(header) + " and readable bytes is " + totalBytes + " on " + phase + " phase");
    }

    @Nullable
    private static SyntheticMetadataMessage decodeInMetadata(ByteBuf buf, short header, ConnectionContext context, MetadataDecodeContext decodeContext) {
        ServerMessage message = 254 == header && EofMessage.isValidSize(buf.readableBytes()) ? EofMessage.decode(buf) : DefinitionMetadataMessage.decode(buf, context);
        if (message instanceof ServerStatusMessage) {
            context.setServerStatuses(((ServerStatusMessage)message).getServerStatuses());
        }
        return decodeContext.putPart(message);
    }
}

